% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtoi.R
\name{region}
\alias{region}
\alias{region,rtoi-method}
\alias{region,rtoi}
\alias{region<-}
\alias{region<-,rtoi}
\alias{region<-,rtoi,sf-method}
\alias{region<-,rtoi,sf}
\alias{region<-,rtoi,NULL-method}
\alias{region<-,rtoi,NULL}
\title{Extracts region from an rtoi}
\usage{
region(x)

\S4method{region}{rtoi}(x)

region(x) <- value

\S4method{region}{rtoi,sf}(x) <- value

\S4method{region}{rtoi,`NULL`}(x) <- value
}
\arguments{
\item{x}{an rtoi object.}

\item{value}{an sf object to define the region in x.}
}
\value{
the sf class with the region of an rtoi
}
\description{
gets the sf that specifies the region of an rtoi.
}
\examples{
library(rsat)
# create a copy of navarre
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

# load example rtoi
navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the region from rtoi
sf.obj <-  region(navarre)
plot(sf.obj)

# asign new region value
region(navarre)<-NULL

region(navarre)<-sf.obj
}
