% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaDisconnect.R
\name{scalaDisconnect}
\alias{scalaDisconnect}
\title{Temporarily Disconnect Scala by Closing Connections}
\usage{
scalaDisconnect(bridge = scalaFindBridge())
}
\arguments{
\item{bridge}{An rscala bridge.}
}
\description{
This function temporarily disconnects an rscala bridge by closing its
associated socket connections.  The primary place where this function is used
is at the end of examples of packages that depend on rscala (because, under
some versions of R, "\code{R CMD check --as-cran}" does not permit
connections to persist after an example ends).
}
\examples{
\donttest{

showConnections()
s <- scala()
showConnections()         # No additional connections yet.
s * "3+4"
showConnections()         # Now there are two additional connections.
scalaDisconnect()
showConnections()         # The new connections are gone.
s * "3+4"
showConnections()         # New connections are established as needed.
close(s)
}
}
