% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R, R/extendr-wrappers.R
\name{geom_point}
\alias{geom_point}
\alias{geom_multipoint}
\alias{geom_linestring}
\alias{geom_polygon}
\alias{geom_line}
\title{Construct Geometries}
\usage{
geom_point(x, y)

geom_multipoint(x, y, id = 1)

geom_linestring(x, y, id = 1)

geom_polygon(x, y, id = 1, ring = 1)

geom_line(x, y)
}
\arguments{
\item{x}{a vector of x coordinates}

\item{y}{a vector of y coordinates}

\item{id}{the feature identifier}

\item{ring}{the id of the polygon ring}
}
\value{
an object of class \code{rsgeo}
}
\description{
Constructs geometries from numeric vectors.
}
\details{
In the case of \code{geom_line()}, both \code{x} and \code{y} are vectors of \code{rs_POINT}
geometries. \code{geom_line()} creates a straight line between two points.
}
\examples{
geom_point(3, 0.14)
geom_multipoint(1:10, 10:1)
geom_linestring(1:10, 10:1)
geom_polygon(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0))
x <- geom_point(0, 0)
y <- geom_point(5, 0)
geom_line(x, y)
}
