% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{densify_euclidean}
\alias{densify_euclidean}
\alias{densify_haversine}
\title{Densify linear geometries}
\usage{
densify_euclidean(x, max_distance)

densify_haversine(x, max_distance)
}
\arguments{
\item{x}{an object with linear geometries. Can be an \code{rsgeo} object \emph{except}
\code{"rs_POINT"} or \code{"rs_MULTIPOINT"}.}

\item{max_distance}{the maximum allowed distance between coordinates.}
}
\description{
Adds coordinates along a \code{LineString} ensuring that no two coordinates are
further than a maximum distance apart from eachother.
}
\details{
\code{max_distance} expects meters for \code{densify_haversine()} whereas
\code{densify_euclidean()} expects the units of the geometry.

Be sure to use the appropriate densification function based on
the type of geometries you have. rsgeo does not check if your coordinates
are geographic or planar. It is up to you to choose the correct algorithm.
}
\examples{

line <- geom_linestring(1:10, 10:1)
densify_euclidean(line, 0.5)
densify_haversine(line, 100000)

}
