## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.height = 3, fig.width = 5,
  out.width = "80%"
)

## ----packages---------------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)
library(ggplot2)

## ----data-1-----------------------------------------------------------------------------------------------------------------------------------------
data("relhaz", package = "rsimsum")

## ----inspect-1--------------------------------------------------------------------------------------------------------------------------------------
str(relhaz)
head(relhaz, n = 15)

## ----summarise-1------------------------------------------------------------------------------------------------------------------------------------
s1 <- simsum(
  data = relhaz, estvarname = "theta", se = "se", true = -0.50,
  methodvar = "model", by = c("n", "baseline"), x = TRUE
)
s1

## ----summary-summarise-1----------------------------------------------------------------------------------------------------------------------------
summary(s1)

## ----plot-est---------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "est")

## ----plot-se----------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "se")

## ----plot-est-ba------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "est_ba")

## ----ridge-est-1------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "est_ridge")

## ----lolly-bias-1-----------------------------------------------------------------------------------------------------------------------------------
autoplot(summary(s1), type = "lolly", stats = "bias")

## ----lolly-bias-2-----------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "lolly", stats = "bias")

## ----lolly-coverage-1-------------------------------------------------------------------------------------------------------------------------------
autoplot(summary(s1), type = "lolly", stats = "cover")

## ----forest-bias-1----------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "forest", stats = "bias")

## ----forest-bias-2----------------------------------------------------------------------------------------------------------------------------------
autoplot(summary(s1), type = "forest", stats = "bias")

## ----zipper-1---------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "zip")

## ----heat-bias-1------------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "heat", stats = "bias")

## ----add-theme--------------------------------------------------------------------------------------------------------------------------------------
autoplot(summary(s1), type = "lolly", stats = "bias") +
  ggplot2::theme_bw()

## ----add-theme-default------------------------------------------------------------------------------------------------------------------------------
autoplot(summary(s1), type = "lolly", stats = "bias")

## ----heat-bias-viridis------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "heat", stats = "bias") +
  viridis::scale_fill_viridis()

## ----colour-palette---------------------------------------------------------------------------------------------------------------------------------
autoplot(s1, type = "est_ridge") +
  viridis::scale_fill_viridis(discrete = TRUE) +
  viridis::scale_colour_viridis(discrete = TRUE)

