% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_R2.R
\name{bayes_R2.stanreg}
\alias{bayes_R2}
\alias{bayes_R2.stanreg}
\title{Compute a Bayesian version of R-squared for regression models}
\usage{
\method{bayes_R2}{stanreg}(object, newdata = NULL, re.form = NULL,
  offset = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{newdata}{Similar to the \code{newdata} argument to 
\code{\link{posterior_linpred}} and \code{\link{posterior_predict}} except,
in addition to new observations of the predictors, new observations of the
\emph{outcome} must be also included. See the \strong{Examples} section below.}

\item{re.form, offset}{For models with group-level terms, these arguments are 
passed to \code{\link{posterior_linpred}} if the \code{newdata} argument is
specified.}

\item{...}{Currently ignored.}
}
\value{
A vector of Bayesian R-squared values with length equal to the 
  posterior sample size.
}
\description{
Compute a Bayesian version of R-squared for regression models
}
\examples{
fit <- stan_glm(mpg ~ wt + cyl, data = mtcars, QR = TRUE, chains = 2)
rsq <- bayes_R2(fit)
print(median(rsq))

# specifying newdata (including outcome variable 'mpg')
nd <- data.frame(mpg = c(10, 20, 30), wt = c(4, 3, 2), cyl = c(8, 6, 4))
rsq_new <- bayes_R2(fit, newdata = nd)
print(median(rsq_new))

# multilevel binomial model
if (!exists("example_model")) example(example_model)
print(example_model)
median(bayes_R2(example_model))
median(bayes_R2(example_model, re.form = NA)) # exclude group-level

}
\seealso{
\url{https://github.com/jgabry/bayes_R2}
}

