% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunn_test.R
\name{dunn_test}
\alias{dunn_test}
\title{Dunn's Test of Multiple Comparisons}
\usage{
dunn_test(data, formula, p.adjust.method = "holm")
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}
}
\value{
return a data frame with some of the following columns: \itemize{
 \item \code{.y.}: the y (outcome) variable used in the test. \item
 \code{group1,group2}: the compared groups in the pairwise tests. \item
 \code{statistic}: Test statistic (z-value) used to compute the p-value. \item
 \code{p}: p-value. \item \code{p.adj}: the adjusted p-value. \item
 \code{method}: the statistical test used to compare groups. \item
 \code{p.signif, p.adj.signif}: the significance level of p-values and
 adjusted p-values, respectively. }

 The \strong{returned object has an attribute called args}, which is a list holding
 the test arguments.
}
\description{
Performs Dunn's test for pairwise multiple comparisons of the
 ranked data. The mean rank of the different groups is compared. Used for
 post-hoc test following Kruskal-Wallis test.
}
\examples{
ToothGrowth \%>\% dunn_test(len ~ dose)
}
\references{
Dunn, O. J. (1964) Multiple comparisons using rank sums Technometrics, 6(3):241-252.
}
