/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.examples;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Random;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.FullDataRecord;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.StandardQF;
import org.vikamine.kernel.subgroup.search.BSD;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class CreateDatasetExample {
    public static void main(String[] args) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int i = 0;
        while (i < 10) {
            String attributeName = "Attribute_" + i;
            ArrayList<String> rawValuesList = new ArrayList<String>();
            rawValuesList.add("true");
            rawValuesList.add("false");
            AttributeBuilder attBuilder = new AttributeBuilder();
            attBuilder.buildNominalAttribute(attributeName, rawValuesList);
            attBuilder.buildNominalValues();
            attributes.add(attBuilder.getAttribute());
            ++i;
        }
        DataRecordSet drs = new DataRecordSet("myDataset", attributes);
        Random random = new Random();
        int numAttributes = drs.getNumAttributes();
        int i2 = 0;
        while (i2 < 100) {
            double[] values = new double[numAttributes];
            int attIndex = 0;
            while (attIndex < numAttributes) {
                boolean valueForAttributeOnIndex = random.nextBoolean();
                values[attIndex] = valueForAttributeOnIndex ? 0.0 : 1.0;
                ++attIndex;
            }
            FullDataRecord dr = new FullDataRecord(1.0, values);
            drs.add(dr);
            ++i2;
        }
        Ontology onto = DataFactory.createOntology(drs);
        System.out.println("Number of instances in the data: " + onto.getDataset().getNumInstances());
        System.out.println("Number of attributes in the data (including id): " + onto.getDataset().getNumAttributes());
        CreateDatasetExample.doSomeSGSearch(onto, "Attribute_0", "true");
    }

    private static void doSomeSGSearch(Ontology onto, String targetAttributeName, String targetValue) {
        System.out.println("");
        System.out.println("Result from a sample Subgroup Discovery on this data:");
        MiningTask task = new MiningTask();
        task.setOntology(onto);
        DefaultSGSelector selector = new DefaultSGSelector(onto, targetAttributeName, targetValue);
        SelectorTarget target = new SelectorTarget(selector);
        task.setTarget(target);
        LinkedHashSet<Attribute> attributes = onto.getAttributes();
        attributes.remove(onto.getIDAttribute());
        attributes.removeAll(target.getAttributes());
        SGSelectorGenerator.SimpleValueSelectorGenerator generator = new SGSelectorGenerator.SimpleValueSelectorGenerator();
        task.setSearchSpace(SelectorGeneratorUtils.generateSelectors(generator, attributes, onto.getDataView()));
        SG initialSG = new SG(onto.getDataView(), task.getTarget());
        initialSG.createStatistics(null);
        task.setInitialSG(initialSG);
        task.setQualityFunction(new StandardQF(0.5));
        task.setMethodType(BSD.class);
        task.setMaxSGDSize(2);
        task.setMaxSGCount(10);
        SGSet result = task.performSubgroupDiscovery();
        result = new SGFilters.MinImprovementFilterGlobal(0.0).filterSGs(result);
        for (SG sg : result.toSortedList(false)) {
            System.out.println(sg.getSGDescription() + " - " + sg.getStatistics().getSubgroupSize() + "(" + sg.getStatistics().getDeviation() + ")");
        }
    }
}

