/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.formula.ConstantParserElementBuilder;
import org.vikamine.kernel.formula.ParserElement;
import org.vikamine.kernel.formula.ParserElementBuilder;
import org.vikamine.kernel.formula.Scanner;
import org.vikamine.kernel.formula.TrieNode;
import org.vikamine.kernel.formula.VariableParserElementBuilder;
import org.vikamine.kernel.formula.exception.AmbiguousTokenException;
import org.vikamine.kernel.formula.exception.UnknownTokenException;

public class DefaultScanner
implements Scanner {
    protected TrieNode constantElements = new TrieNode();
    protected List variableElements = new LinkedList();

    @Override
    public void registerVariableElement(VariableParserElementBuilder elementBuilder) {
        this.variableElements.add(elementBuilder);
    }

    @Override
    public void registerConstantElement(ConstantParserElementBuilder elementBuilder) {
        if (this.containsConstantElement(elementBuilder.getText())) {
            throw new IllegalArgumentException("A element with this text already exists: " + elementBuilder.getText());
        }
        this.constantElements.put(elementBuilder.getText(), elementBuilder);
    }

    public TrieNode getConstantElements() {
        return this.constantElements;
    }

    @Override
    public boolean containsConstantElement(String constantString) {
        TrieNode old = this.constantElements.getNode(constantString, false);
        return old != null && old.hasValue();
    }

    @Override
    public List scan(String text) throws ParseException {
        List recognizedTokens = this.scanTokens(text);
        List parserElements = this.buildParserElements(recognizedTokens);
        return parserElements;
    }

    protected List buildParserElements(List tokens) throws UnknownTokenException {
        ArrayList<ParserElement> parserElements = new ArrayList<ParserElement>(tokens.size());
        for (RecognizedToken tokk : tokens) {
            List before = Collections.unmodifiableList(parserElements);
            ParserElement pe = tokk.getBuilder().createParserElement(tokk.getToken(), before);
            if (pe.getType() != null && pe.getType().equals(Exception.class)) {
                throw new UnknownTokenException("Unknown text " + pe.getContent(), -1, pe.getToken());
            }
            parserElements.add(pe);
        }
        return parserElements;
    }

    protected List scanTokens(String text) throws ParseException {
        LinkedList<RecognizedToken> elements = new LinkedList<RecognizedToken>();
        int i = 0;
        while (i < text.length()) {
            RecognizedToken token = this.scanNextToken(text.substring(i), i);
            if (token != null) {
                elements.add(token);
                i += token.getLength();
                continue;
            }
            if (!this.ignore(text.charAt(i))) {
                throw new UnknownTokenException("Unknown text: " + text.substring(i), i, text.substring(i));
            }
            ++i;
        }
        return elements;
    }

    protected RecognizedToken scanNextToken(String text, int position) throws ParseException {
        RecognizedToken constant = this.scanConstantToken(text);
        RecognizedToken variable = this.scanVariableToken(text, position);
        return this.getLongerToken(constant, variable, position);
    }

    protected RecognizedToken scanVariableToken(String text, int position) throws ParseException {
        LinkedList lastValid = new LinkedList();
        LinkedList validSubstrings = new LinkedList(this.variableElements);
        int i = 0;
        while (i < text.length() && !validSubstrings.isEmpty()) {
            String substring = text.substring(0, i + 1);
            LinkedList<RecognizedToken> valid = new LinkedList<RecognizedToken>();
            Iterator iter = validSubstrings.iterator();
            while (iter.hasNext()) {
                VariableParserElementBuilder builder = (VariableParserElementBuilder)iter.next();
                if (!builder.isValidStart(substring)) {
                    iter.remove();
                } else if (builder.isValid(substring)) {
                    valid.add(new RecognizedToken(builder, substring));
                }
                if (valid.isEmpty()) continue;
                lastValid = valid;
            }
            ++i;
        }
        if (lastValid.isEmpty()) {
            return null;
        }
        if (lastValid.size() == 1) {
            return (RecognizedToken)lastValid.get(0);
        }
        RecognizedToken t1 = (RecognizedToken)lastValid.get(0);
        AmbiguousTokenException ex = new AmbiguousTokenException("ambiguous token: " + t1.getToken(), position, t1.getToken());
        for (RecognizedToken tok : lastValid) {
            ex.addPossibleBuilder(tok.builder);
        }
        throw ex;
    }

    protected RecognizedToken scanConstantToken(String text) {
        RecognizedToken lastToken = null;
        TrieNode node = this.constantElements;
        int i = 0;
        while (i < text.length() && node != null) {
            if ((node = node.getChild(text.charAt(i), false)) != null && node.hasValue()) {
                lastToken = new RecognizedToken((ParserElementBuilder)node.getValue(), text.substring(0, i + 1));
            }
            ++i;
        }
        return lastToken;
    }

    protected RecognizedToken getLongerToken(RecognizedToken t1, RecognizedToken t2, int position) throws ParseException {
        if (t1 != null && t2 != null) {
            if (t1.getLength() > t2.getLength()) {
                return t1;
            }
            if (t1.getLength() < t2.getLength()) {
                return t2;
            }
            AmbiguousTokenException ex = new AmbiguousTokenException("Text is ambivalent: " + t1.getToken(), position, t1.getToken());
            ex.addPossibleBuilder(t1.getBuilder());
            ex.addPossibleBuilder(t2.getBuilder());
            throw ex;
        }
        if (t1 != null) {
            return t1;
        }
        return t2;
    }

    protected boolean ignore(char c) {
        return Character.isWhitespace(c);
    }

    protected static class RecognizedToken {
        protected ParserElementBuilder builder;
        protected String token;

        public RecognizedToken(ParserElementBuilder builder, String token) {
            this.builder = builder;
            this.token = token;
        }

        public ParserElementBuilder getBuilder() {
            return this.builder;
        }

        public void setBuilder(ParserElementBuilder builder) {
            this.builder = builder;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public int getLength() {
            return this.getToken().length();
        }
    }
}

