/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.Collections;
import java.util.Iterator;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SGStatisticsBinary
extends SGStatistics {
    protected double positives;
    protected double negatives;
    protected double tp;
    protected double fp;

    protected SGStatisticsBinary(SG subgroup) {
        super(subgroup);
    }

    @Override
    public double getTargetQuantitySG() {
        return this.getP();
    }

    @Override
    public double getTargetQuantityPopulation() {
        return this.getP0();
    }

    protected SGStatisticsBinary(SG subgroup, Options options) {
        super(subgroup, options);
    }

    @Override
    protected void calculateStatistics() {
        this.descriptionLength = this.subgroup.getSGDescription().size();
        Iterator<DataRecord> iter = this.subgroup.getPopulation().instanceIterator();
        while (iter.hasNext()) {
            DataRecord instance = iter.next();
            if (this.isInstanceDefinedForSubgroupVars(instance)) {
                this.definedPopulationCount += 1.0;
                SGDescription description = this.subgroup.getSGDescription();
                SGTarget target = this.subgroup.getTarget();
                if (target instanceof BooleanTarget) {
                    if (((BooleanTarget)target).isPositive(instance)) {
                        this.positives += 1.0;
                        if (!description.isMatching(instance)) continue;
                        this.tp += instance.getWeight();
                        this.subgroupSize += instance.getWeight();
                        continue;
                    }
                    this.negatives += 1.0;
                    if (!description.isMatching(instance)) continue;
                    this.fp += instance.getWeight();
                    this.subgroupSize += instance.getWeight();
                    continue;
                }
                if (!description.isMatching(instance)) continue;
                this.subgroupSize += instance.getWeight();
                continue;
            }
            this.undefinedPopulationCount += 1.0;
        }
    }

    @Override
    public boolean isTargetDefinedInInstance(SGTarget target, DataRecord instance) {
        if (this.treatMissingAsDefinedValueForAttributes(target.getAttributes())) {
            return true;
        }
        for (Attribute att : target.getAttributes()) {
            Value missing = Value.missingValue(att);
            if (!missing.isValueContainedInInstance(instance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSGSelectorSetDefinedInInstance(DataRecord instance) {
        for (SGSelector sel : this.subgroup.getSGDescription()) {
            Attribute att = sel.getAttribute();
            if (this.isAttributeDefinedInInstance(instance, att)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAttributeDefinedInInstance(DataRecord instance, Attribute attribute) {
        return !instance.isMissing(attribute) || this.treatMissingAsDefinedValueForAttributes(Collections.singletonList(attribute));
    }

    @Override
    public boolean isInstanceDefinedForSubgroupVars(DataRecord instance) {
        if (this.subgroup.getTarget() != null && !this.isTargetDefinedInInstance(this.subgroup.getTarget(), instance)) {
            return false;
        }
        return this.isSGSelectorSetDefinedInInstance(instance);
    }

    public double getP0() {
        return this.getPositives() / this.getDefinedPopulationCount();
    }

    public double getP() {
        return this.tp / this.getSubgroupSize();
    }

    public double getFp() {
        return this.fp;
    }

    public double getFn() {
        return this.getPositives() - this.getTp();
    }

    public double getTn() {
        return this.getNegatives() - this.getFp();
    }

    public double getNegatives() {
        return this.negatives;
    }

    @Override
    public double getDeviation() {
        return this.getP() - this.getP0();
    }

    public double getPositives() {
        return this.positives;
    }

    public double getTp() {
        return this.tp;
    }

    public double getSubgroupShareOfPositives() {
        return this.getTp() / (this.getTp() + this.getFn());
    }

    @Override
    public double getSubgroupShareOfPopulation() {
        return (this.getTp() + this.getFp()) / this.getDefinedPopulationCount();
    }

    @Override
    public String toString() {
        return "SGStatistics for (" + SG.verbalizeSGAsPrologLikeRule(this.getSubgroup()) + ")\n" + "DataView: " + this.definedPopulationCount + "(" + this.undefinedPopulationCount + ")\n" + "Positives: " + this.positives + "\n" + "Negatives: " + this.negatives + "\n" + "P0: " + this.getP0() + "\n" + "SubgroupSize: " + this.subgroupSize + "\n" + "TP: " + this.tp + "\n" + "FP: " + this.fp + "\n" + "P: " + this.getP();
    }

    @Override
    public boolean isBinary() {
        return true;
    }
}

