/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQL2CSVConvert {
    public static void createCSVFile(ResultSet result, File file) throws SQLException, IOException {
        ResultSetMetaData metaData = result.getMetaData();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        int columnCount = metaData.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            writer.write(metaData.getColumnName(i));
            if (i != columnCount) {
                writer.write(",");
            }
            ++i;
        }
        writer.write("\n");
        while (result.next()) {
            i = 1;
            while (i <= columnCount) {
                String value = result.getString(i);
                if (value == null) {
                    value = "?";
                }
                value = value.replaceAll("\r\n", "////");
                value = value.replaceAll("\r", "////");
                value = value.replaceAll("\n", "////");
                value = value.replaceAll("'", "");
                value = value.replaceAll("\"", "");
                value = value.replaceAll(";", "");
                value = value.replaceAll(",", "");
                writer.write("'" + value + "'");
                if (i != columnCount) {
                    writer.write(",");
                } else {
                    writer.write("\n");
                }
                ++i;
            }
            writer.flush();
        }
        writer.flush();
        writer.close();
    }
}

