/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.DirectoryDatasetProvider;
import org.vikamine.kernel.xpdl.MiningTaskInterpreter;

public class MiningTask2XML {
    public static void main(String[] args) throws IOException {
        DirectoryDatasetProvider provider = new DirectoryDatasetProvider("../VKM-UCI-Test/resources/datasets/");
        MiningTaskInterpreter interpreter = new MiningTaskInterpreter(new File("../VKM-UCI-Test/resources/tests/simple/credit-g_nominal.xml"), (DatasetProvider)provider);
        MiningTask task = interpreter.getTask();
        MiningTask2XML.exportMiningTask(task, new File("C:/test/task.xml"));
    }

    public static void exportMiningTask(MiningTask task, File exportFilename) throws IOException {
        Element root = new Element("miningTask");
        root.addContent(MiningTask2XML.getDatasetElement(task));
        root.addContent(MiningTask2XML.getTargetElement(task.getTarget()));
        root.addContent(MiningTask2XML.getSearchSpaceElement(task));
        root.addContent(MiningTask2XML.getQualityFunctionElement(task));
        root.addContent(MiningTask2XML.getMethodElement(task));
        root.addContent(MiningTask2XML.getConstraintsElement(task));
        Document doc = new Document(root);
        new XMLOutputter(Format.getPrettyFormat()).output(doc, (Writer)new FileWriter(exportFilename));
    }

    private static Element getConstraintsElement(MiningTask task) {
        Element result = new Element("constraints");
        Element cElem = new Element("constraint");
        cElem.setAttribute("name", "maxK");
        cElem.setAttribute("value", String.valueOf(task.getMaxSGCount()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "minQuality");
        cElem.setAttribute("value", String.valueOf(task.getMinQualityLimit()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "maxSelectors");
        cElem.setAttribute("value", String.valueOf(task.getMaxSGDSize()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "minSubgroupSize");
        cElem.setAttribute("value", String.valueOf(task.getMinSubgroupSize()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "minTPSupportRelative");
        cElem.setAttribute("value", String.valueOf(task.getMinTPSupportRelative()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "minTPSupportAbsolute");
        cElem.setAttribute("value", String.valueOf(task.getMinTPSupportAbsolute()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "relevantSubgroupsOnly");
        cElem.setAttribute("value", String.valueOf(task.isSuppressStrictlyIrrelevantSubgroups()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "weightedCovering");
        cElem.setAttribute("value", String.valueOf(task.isWeightedCovering()));
        result.addContent(cElem);
        cElem = new Element("constraint");
        cElem.setAttribute("name", "ignoreDefaultValues");
        cElem.setAttribute("value", String.valueOf(task.isIgnoreDefaultValues()));
        result.addContent(cElem);
        return result;
    }

    private static Element getMethodElement(MiningTask task) {
        Element qElem = new Element("method");
        qElem.setAttribute("name", task.getMethodType().getSimpleName());
        return qElem;
    }

    private static Element getQualityFunctionElement(MiningTask task) {
        Element qElem = new Element("qualityFunction");
        qElem.setAttribute("name", task.getQualityFunction().getName());
        return qElem;
    }

    private static Element getSearchSpaceElement(MiningTask task) {
        Element targetElem = new Element("searchSpace");
        for (Attribute att : task.getAttributes()) {
            Element element = new Element("attribute");
            element.setAttribute("name", att.getDescription());
            targetElem.addContent(element);
        }
        return targetElem;
    }

    private static Element getTargetElement(SGTarget target) {
        Element targetElem = new Element("target");
        if (target instanceof SelectorTarget) {
            SelectorTarget selTarget = (SelectorTarget)target;
            targetElem.setAttribute("type", "boolean");
            targetElem.addContent(MiningTask2XML.getSelectorElement(selTarget.getSelector()));
        }
        if (target instanceof NumericTarget) {
            targetElem.setAttribute("type", "numeric");
            Element attElement = new Element("attribute");
            attElement.setAttribute("name", target.getAttributes().iterator().next().getDescription());
            targetElem.addContent(attElement);
        }
        return targetElem;
    }

    private static Element getSelectorElement(SGSelector selector) {
        Element selElement = new Element("attribute");
        selElement.setAttribute("name", selector.getAttribute().getDescription());
        if (selector instanceof SGNominalSelector) {
            Set<Value> values = ((SGNominalSelector)selector).getValues();
            for (Value val : values) {
                Element includeElement = new Element("includeValue");
                includeElement.addContent(val.getDescription());
                selElement.addContent(includeElement);
            }
        }
        return selElement;
    }

    private static Element getDatasetElement(MiningTask task) {
        Element datasetElem = new Element("dataset");
        String datasetName = (String)task.getOntology().getTripleStore().getFirstMatchingStatement("**ANY_OBJECT**", OntologyConstants.DATASET_FILE_NAME_PROPERTY, "**ANY_OBJECT**").getObject();
        datasetElem.setAttribute("name", datasetName);
        datasetElem.addContent(new Element("restrictions"));
        return datasetElem;
    }
}

