/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class DyadicMultiWeightedLiftQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicMultiWeightedLiftQF";
    private static final String NAME = "DyadicMultiWeightedLiftQF";

    @Override
    public String getID() {
        return "DyadicMultiWeightedLiftQF";
    }

    @Override
    public String getName() {
        return "DyadicMultiWeightedLiftQF";
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicMultiWeightedLiftQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double weightedObservedDyads = statistics.getTargetQuantitySG() * statistics.getSubgroupSize();
        HashSet<String> nodes = new HashSet<String>();
        HashMap multiEdgesCount = new HashMap();
        for (DataRecord record : subgroup) {
            String valSrc = ((NominalAttribute)record.getDataset().getAttribute(0)).getNominalValue(record).getId();
            String valDst = ((NominalAttribute)record.getDataset().getAttribute(1)).getNominalValue(record).getId();
            HashSet<String> edge = new HashSet<String>();
            edge.add(valSrc);
            edge.add(valDst);
            if (multiEdgesCount.get(edge) != null) {
                int edgeCount = (Integer)multiEdgesCount.get(edge) + 1;
                multiEdgesCount.put(edge, edgeCount);
            } else {
                multiEdgesCount.put(edge, 0);
            }
            nodes.add(valSrc);
            nodes.add(valDst);
        }
        int count = nodes.size();
        double expectedDyads = (double)count * (double)(count - 1) / 2.0;
        int onlyMultiEdgeCountOverhead = 0;
        for (Map.Entry mapEntry : multiEdgesCount.entrySet()) {
            int edgeCount = (Integer)mapEntry.getValue();
            onlyMultiEdgeCountOverhead += edgeCount;
        }
        return Math.abs(weightedObservedDyads / (expectedDyads += (double)onlyMultiEdgeCountOverhead));
    }
}

