:- compiler_options([allow_redefinition]).
:- import set_unify/2 from set_unify.
:- import numbervars/1 from num_vars.
:- import normalize_result/2 from can_mono.

test :- tp, fail.
test :- writeln('=========== Result is ================'), nl, show_facts.

unify_sets([],[]).
unify_sets([A|As],[B|Bs]) :- 
       set_unify(A,B), unify_sets(As,Bs).

/* This file (wrongly?) makes calls to current_op/3 with arguments
instantiated to lists, so the test ceased to work when I put in ISO
error-testing.  Thus the patch -- TLS.  */

local_current_op(X,Y,Z):-
	(integer(X) ; var(X)),(atom(Y) ; var(Y)),(atom(Z) ; var(Z)),
	current_op(X,Y,Z).

%---------------- Transformed program ----------------------

read_tokens__1(_376,_378) :- 
        [_315] = _380, [_339] = _382, 
        read_tokens([num],[_348],[_315]),
        append([_348],[list],[_348]),
        'my ='([_339],[_348]),
        normalize_result([_380,_382],
                         [_376,_378]).
read_tokens__1(_126,_128) :- 
        [list,list] = _130, [list] = _132, 
        normalize_result([_130,_132],
                          [_126,_128]).
display__1(_103) :- 
        [list,list] = _105, 
        normalize_result([_105],
                          [_103]).
my_get0__1(_103) :- 
        [list,list] = _105, 
        normalize_result([_105],
                          [_103]).
read_tokens__1(_215,_217,_219) :- 
        [num] = _221, [_163] = _223, [_167] = _225, 
        'my ='([num],[num]),
        normalize_result([_221,_223,_225],
                         [_215,_217,_219]).
read_tokens__1(_359,_361,_363) :- 
        [_298] = _365, [_326] = _367, [_330] = _369, 
        'my =<'([_298],[num]),
        my_get0([_322]),
        read_tokens([_322],[_326],[_330]),
        normalize_result([_365,_367,_369],
                         [_359,_361,_363]).
read_tokens__1(_396,_398,_400) :- 
        [num] = _402, [_360] = _404, [_364] = _406, 
        my_get0([_332]),
        'my =\\='([_332],[num]),
        my_get0([_356]),
        read_tokens([_356],[_360],[_364]),
        normalize_result([_402,_404,_406],
                         [_396,_398,_400]).
read_tokens__1(_296,_298,_300) :- 
        [num] = _302, [_266] = _304, [_270] = _306, 
        my_get0([_262]),
        read_solidus([_262],[_266],[_270]),
        normalize_result([_302,_304,_306],
                         [_296,_298,_300]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_after_atom([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_tokens__1(_296,_298,_300) :- 
        [num] = _302, [_266] = _304, [_270] = _306, 
        my_get0([_262]),
        read_fullstop([_262],[_266],[_270]),
        normalize_result([_302,_304,_306],
                         [_296,_298,_300]).
read_tokens__1(_354,_356,_358) :- 
        [num] = _360, [_324] = _362, [list,_328] = _364, 
        read_string([_304],[num],[_320]),
        read_tokens([_320],[_324],[_328]),
        normalize_result([_360,_362,_364],
                         [_354,_356,_358]).
read_tokens__1(_397,_399,_401) :- 
        [num] = _403, [_364] = _405, [list,_368] = _407, 
        read_string([_338],[num],[_360]),
        getname([_354]),
        read_after_atom([_360],[_364],[_368]),
        normalize_result([_403,_405,_407],
                         [_397,_399,_401]).
read_tokens__1(_583,_585,_587) :- 
        [_504] = _589, [_541] = _591, [list,_545] = _593, 
        'my >='([_504],[num]),
        'my =<'([_504],[num]),
        read_name([_504],[_508],[_537]),
        getname([_520]),
        read_lookup([_541],[other]),
        read_tokens([_537],[_541],[_545]),
        normalize_result([_589,_591,_593],
                         [_583,_585,_587]).
read_tokens__1(_478,_480,_482) :- 
        [_422] = _484, [_442] = _486, [list,_446] = _488, 
        'my >='([_422],[num]),
        'my =<'([_422],[num]),
        read_integer([_422],[_426],[_438]),
        read_tokens([_438],[_442],[_446]),
        normalize_result([_484,_486,_488],
                         [_478,_480,_482]).
read_tokens__1(_521,_523,_525) :- 
        [_456] = _527, [_482] = _529, [list,_486] = _531, 
        'my >='([_456],[num]),
        'my =<'([_456],[num]),
        read_name([_456],[_460],[_478]),
        getname([_472]),
        read_after_atom([_478],[_482],[_486]),
        normalize_result([_527,_529,_531],
                         [_521,_523,_525]).
read_tokens__1(_450,_452,_454) :- 
        [_357] = _456, [_414] = _458, [list,_418] = _460, 
        my_get0([_388]),
        read_symbol([_388],[_392],[_410]),
        getname([_404]),
        read_after_atom([_410],[_414],[_418]),
        normalize_result([_456,_458,_460],
                         [_450,_452,_454]).
getname__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
getname__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
read_after_atom__1(_306,_308,_310) :- 
        [num] = _312, [_276] = _314, [list,_280] = _316, 
        my_get0([_272]),
        read_tokens([_272],[_276],[_280]),
        normalize_result([_312,_314,_316],
                         [_306,_308,_310]).
read_after_atom__1(_259,_261,_263) :- 
        [_228] = _265, [_232] = _267, [_236] = _269, 
        read_tokens([_228],[_232],[_236]),
        normalize_result([_265,_267,_269],
                         [_259,_261,_263]).
read_string__1(_327,_329,_331) :- 
        [_292] = _333, [_296] = _335, [_300] = _337, 
        my_get0([_288]),
        read_string([_288],[_292],[_296],[_300]),
        normalize_result([_333,_335,_337],
                         [_327,_329,_331]).
read_string__1(_363,_365,_367,_369) :- 
        [num] = _371, [_283] = _373, [_325] = _375, [num] = _377, 
        my_display([atom]),
        ttyput([_325]),
        my_display([atom]),
        ttyput([_325]),
        ttynl,
        fail,
        normalize_result([_371,_373,_375,_377],
                         [_363,_365,_367,_369]).
read_string__1(_354,_356,_358,_360) :- 
        [_317] = _362, [_321] = _364, [_317] = _366, [_325] = _368, 
        my_get0([_313]),
        more_string([_313],[_317],[_321],[_325]),
        normalize_result([_362,_364,_366,_368],
                         [_354,_356,_358,_360]).
read_string__1(_298,_300,_302,_304) :- 
        [_235] = _306, [list,_265] = _308, [_269] = _310, [_273] = _312, 
        read_string([_265],[_269],[_273]),
        normalize_result([_306,_308,_310,_312],
                         [_298,_300,_302,_304]).
more_string__1(_296,_298,_300,_302) :- 
        [_267] = _304, [_267] = _306, [list,_263] = _308, [_271] = _310, 
        read_string([_263],[_267],[_271]),
        normalize_result([_304,_306,_308,_310],
                         [_296,_298,_300,_302]).
more_string__1(_178,_180,_182,_184) :- 
        [_159] = _186, [_151] = _188, [list] = _190, [_159] = _192, 
        normalize_result([_186,_188,_190,_192],
                          [_178,_180,_182,_184]).
ttyput__1(_99) :- 
        [_89] = _101, 
        normalize_result([_101],
                          [_99]).
ttynl__1 :- 
        normalize_result([],
                          []).
read_solidus__1(_364,_366,_368) :- 
        [num] = _370, [_331] = _372, [_335] = _374, 
        my_get0([_316]),
        read_solidus([_316],[_327]),
        read_tokens([_327],[_331],[_335]),
        normalize_result([_370,_372,_374],
                         [_364,_366,_368]).
read_solidus__1(_407,_409,_411) :- 
        [_348] = _413, [_374] = _415, [list,_378] = _417, 
        read_symbol([_348],[_352],[_370]),
        getname([_364]),
        read_tokens([_370],[_374],[_378]),
        normalize_result([_413,_415,_417],
                         [_407,_409,_411]).
read_solidus__1(_175,_177) :- 
        [num] = _179, [num] = _181, 
        my_display([atom]),
        ttynl,
        normalize_result([_179,_181],
                         [_175,_177]).
read_solidus__1(_299,_301) :- 
        [num] = _303, [_273] = _305, 
        my_get0([_269]),
        'my =\\='([_269],[num]),
        read_solidus([_269],[_273]),
        normalize_result([_303,_305],
                         [_299,_301]).
read_solidus__1(_116,_118) :- 
        [num] = _120, [num] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
read_solidus__1(_248,_250) :- 
        [_197] = _252, [_225] = _254, 
        my_get0([_221]),
        read_solidus([_221],[_225]),
        normalize_result([_252,_254],
                         [_248,_250]).
read_name__1(_426,_428,_430) :- 
        [_362] = _432, [list,_390] = _434, [_394] = _436, 
        'my >='([_362],[num]),
        'my =<'([_362],[num]),
        my_get0([_386]),
        read_name([_386],[_390],[_394]),
        normalize_result([_432,_434,_436],
                         [_426,_428,_430]).
read_name__1(_149,_151,_153) :- 
        [_133] = _155, [list] = _157, [_133] = _159, 
        normalize_result([_155,_157,_159],
                          [_149,_151,_153]).
read_symbol__1(_353,_355,_357) :- 
        [_304] = _359, [list,_320] = _361, [_324] = _363, 
        check_special([_304]),
        my_get0([_316]),
        read_symbol([_316],[_320],[_324]),
        normalize_result([_359,_361,_363],
                         [_353,_355,_357]).
read_symbol__1(_149,_151,_153) :- 
        [_133] = _155, [list] = _157, [_133] = _159, 
        normalize_result([_155,_157,_159],
                          [_149,_151,_153]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
check_special__1(_93) :- 
        [atom] = _95, 
        normalize_result([_95],
                          [_93]).
read_fullstop__1(_221,_223,_225) :- 
        [num] = _227, [_175] = _229, [_179] = _231, 
        my_display([atom]),
        ttynl,
        fail,
        normalize_result([_227,_229,_231],
                         [_221,_223,_225]).
read_fullstop__1(_219,_221,_223) :- 
        [_186] = _225, [_167] = _227, [list] = _229, 
        'my =<'([_186],[num]),
        normalize_result([_225,_227,_229],
                         [_219,_221,_223]).
read_fullstop__1(_407,_409,_411) :- 
        [_348] = _413, [_374] = _415, [list,_378] = _417, 
        read_symbol([_348],[_352],[_370]),
        getname([_364]),
        read_tokens([_370],[_374],[_378]),
        normalize_result([_413,_415,_417],
                         [_407,_409,_411]).
read_integer__1(_555,_557,_559) :- 
        [_445] = _561, [_514] = _563, [_518] = _565, 
        'my is'([_506],[[_445],[num]]),
        my_get0([_502]),
        'my =\\='([_502],[num]),
        'my =\\='([_502],[num]),
        read_digits([_502],[_506],[num],[_514],[_518]),
        normalize_result([_561,_563,_565],
                         [_555,_557,_559]).
read_digits__1(_438,_440,_442,_444) :- 
        [_393] = _446, [_397] = _448, [_401] = _450, [_405] = _452, 
        my_get0([_389]),
        'my =\\='([_389],[num]),
        read_digits([_389],[_393],[_397],[_401],[_405]),
        normalize_result([_446,_448,_450,_452],
                         [_438,_440,_442,_444]).
read_digits__1(_617,_619,_621,_623,_625) :- 
        [_557] = _627, [_541] = _629, [_572] = _631, [_576] = _633, [_580] = _635, 
        'my >='([_557],[num]),
        'my =<'([_557],[num]),
        'my is'([_568],[[[[_541],[_572]],[num]],[_557]]),
        read_digits([_568],[_572],[_576],[_580]),
        normalize_result([_627,_629,_631,_633,_635],
                         [_617,_619,_621,_623,_625]).
read_digits__1(_211,_213,_215,_217,_219) :- 
        [_189] = _221, [_185] = _223, [_181] = _225, [_185] = _227, [_189] = _229, 
        normalize_result([_221,_223,_225,_227,_229],
                          [_211,_213,_215,_217,_219]).
read_lookup__1(_138,_140) :- 
        [list,_84] = _142, [_125] = _144, 
        normalize_result([_142,_144],
                          [_138,_140]).
read_lookup__1(_215,_217) :- 
        [list,_191] = _219, [_195] = _221, 
        read_lookup([_191],[_195]),
        normalize_result([_219,_221],
                         [_215,_217]).
append__1(_149,_151,_153) :- 
        [list] = _155, [_133] = _157, [_133] = _159, 
        normalize_result([_155,_157,_159],
                          [_149,_151,_153]).
append__1(_279,_281,_283) :- 
        [list,_248] = _285, [_252] = _287, [list,_256] = _289, 
        append([_248],[_252],[_256]),
        normalize_result([_285,_287,_289],
                         [_279,_281,_283]).
my_read__1(_445,_447) :- 
        [_405] = _449, [_369] = _451, 
        read_tokens([list,_140],[_369]),
        read([list,_140],[num],[_414],[_399]),
        all_read([_399]),
        'my ='([_405],[_414]),
        normalize_result([_449,_451],
                         [_445,_447]).
all_read__1(_93) :- 
        [list] = _95, 
        normalize_result([_95],
                          [_93]).
all_read__1(_232) :- 
        [list,_84] = _234, 
        syntax_error([list,list,list,list,list],[list,_84]),
        normalize_result([_234],
                         [_232]).
expect__1(_165,_167,_169) :- 
        [_139] = _171, [list,_149] = _173, [_149] = _175, 
        normalize_result([_171,_173,_175],
                          [_165,_167,_169]).
expect__1(_270,_272,_274) :- 
        [_213] = _276, [_248] = _278, [_221] = _280, 
        syntax_error([list,list,list,list,list],[_248]),
        normalize_result([_276,_278,_280],
                         [_270,_272,_274]).
prefixop__1(_253,_255,_257) :- 
        [_230] = _259, [_222] = _261, [_222] = _263, 
        local_current_op([_222],[atom],[_230]),
        normalize_result([_259,_261,_263],
                         [_253,_255,_257]).
prefixop__1(_346,_348,_350) :- 
        [_296] = _352, [_313] = _354, [_304] = _356, 
        local_current_op([_313],[atom],[_296]),
        'my is'([_304],[[_313],[num]]),
        normalize_result([_352,_354,_356],
                         [_346,_348,_350]).
postfixop__1(_253,_255,_257) :- 
        [_230] = _259, [_222] = _261, [_222] = _263, 
        local_current_op([_222],[atom],[_230]),
        normalize_result([_259,_261,_263],
                         [_253,_255,_257]).
postfixop__1(_346,_348,_350) :- 
        [_296] = _352, [_304] = _354, [_313] = _356, 
        local_current_op([_313],[atom],[_296]),
        'my is'([_304],[[_313],[num]]),
        normalize_result([_352,_354,_356],
                         [_346,_348,_350]).
infixop__1(_373,_375,_377,_379) :- 
        [_321] = _381, [_329] = _383, [_338] = _385, [_329] = _387, 
        local_current_op([_338],[atom],[_321]),
        'my is'([_329],[[_338],[num]]),
        normalize_result([_381,_383,_385,_387],
                         [_373,_375,_377,_379]).
infixop__1(_373,_375,_377,_379) :- 
        [_321] = _381, [_329] = _383, [_338] = _385, [_338] = _387, 
        local_current_op([_338],[atom],[_321]),
        'my is'([_329],[[_338],[num]]),
        normalize_result([_381,_383,_385,_387],
                         [_373,_375,_377,_379]).
infixop__1(_373,_375,_377,_379) :- 
        [_321] = _381, [_338] = _383, [_338] = _385, [_329] = _387, 
        local_current_op([_338],[atom],[_321]),
        'my is'([_329],[[_338],[num]]),
        normalize_result([_381,_383,_385,_387],
                         [_373,_375,_377,_379]).
ambigop__1(_462,_464,_466,_468,_470,_472) :- 
        [_417] = _474, [_421] = _476, [_425] = _478, [_429] = _480, [_405] = _482, [_409] = _484, 
        postfixop([_417],[_405],[_409]),
        infixop([_417],[_421],[_425],[_429]),
        normalize_result([_474,_476,_478,_480,_482,_484],
                         [_462,_464,_466,_468,_470,_472]).
read__1(_350,_352,_354,_356) :- 
        [list,_311] = _358, [_315] = _360, [_319] = _362, [_323] = _364, 
        read([_307],[_311],[_315],[_319],[_323]),
        normalize_result([_358,_360,_362,_364],
                         [_350,_352,_354,_356]).
read__1(_269,_271,_273,_275) :- 
        [list] = _277, [_213] = _279, [_217] = _281, [_221] = _283, 
        syntax_error([list,list,list],[list]),
        normalize_result([_277,_279,_281,_283],
                         [_269,_271,_273,_275]).
read__1(_578,_580,_582,_584,_586) :- 
        [other] = _588, [list,_490] = _590, [_535] = _592, [_539] = _594, [_543] = _596, 
        read([_490],[num],[_498],[_511]),
        read_args([_511],[_515],[_527]),
        exprtl0([_527],[other],[_535],[_539],[_543]),
        normalize_result([_588,_590,_592,_594,_596],
                         [_578,_580,_582,_584,_586]).
read__1(_363,_365,_367,_369,_371) :- 
        [other] = _373, [_318] = _375, [_326] = _377, [_330] = _379, [_334] = _381, 
        exprtl0([_318],[_322],[_326],[_330],[_334]),
        normalize_result([_373,_375,_377,_379,_381],
                         [_363,_365,_367,_369,_371]).
read__1(_436,_438,_440,_442,_444) :- 
        [other] = _446, [list,_388] = _448, [_396] = _450, [_400] = _452, [_404] = _454, 
        'my is'([_392],[_379]),
        exprtl0([_388],[_392],[_396],[_400],[_404]),
        normalize_result([_446,_448,_450,_452,_454],
                         [_436,_438,_440,_442,_444]).
read__1(_508,_510,_512,_514,_516) :- 
        [other] = _518, [_462] = _520, [_466] = _522, [_470] = _524, [_474] = _526, 
        prefixop([_450],[_454],[_458]),
        after_prefix_op([_450],[_454],[_458],[_462],[_466],[_470],[_474]),
        normalize_result([_518,_520,_522,_524,_526],
                         [_508,_510,_512,_514,_516]).
read__1(_363,_365,_367,_369,_371) :- 
        [other] = _373, [_318] = _375, [_326] = _377, [_330] = _379, [_334] = _381, 
        exprtl0([_318],[_322],[_326],[_330],[_334]),
        normalize_result([_373,_375,_377,_379,_381],
                         [_363,_365,_367,_369,_371]).
read__1(_363,_365,_367,_369,_371) :- 
        [other] = _373, [_318] = _375, [_326] = _377, [_330] = _379, [_334] = _381, 
        exprtl0([_318],[_322],[_326],[_330],[_334]),
        normalize_result([_373,_375,_377,_379,_381],
                         [_363,_365,_367,_369,_371]).
read__1(_367,_369,_371,_373,_375) :- 
        [atom] = _377, [list,_322] = _379, [_330] = _381, [_334] = _383, [_338] = _385, 
        exprtl0([_322],[list],[_330],[_334],[_338]),
        normalize_result([_377,_379,_381,_383,_385],
                         [_367,_369,_371,_373,_375]).
read__1(_582,_584,_586,_588,_590) :- 
        [atom] = _592, [_492] = _594, [_539] = _596, [_543] = _598, [_547] = _600, 
        read([_492],[num],[_500],[_513]),
        read_list([_513],[_517],[_529]),
        exprtl0([_529],[list,_517],[_539],[_543],[_547]),
        normalize_result([_592,_594,_596,_598,_600],
                         [_582,_584,_586,_588,_590]).
read__1(_566,_568,_570,_572,_574) :- 
        [atom] = _576, [_478] = _578, [_523] = _580, [_527] = _582, [_531] = _584, 
        read([_478],[num],[_519],[_503]),
        expect([atom],[_503],[_515]),
        exprtl0([_515],[_519],[_523],[_527],[_531]),
        normalize_result([_576,_578,_580,_582,_584],
                         [_566,_568,_570,_572,_574]).
read__1(_566,_568,_570,_572,_574) :- 
        [atom] = _576, [_478] = _578, [_523] = _580, [_527] = _582, [_531] = _584, 
        read([_478],[num],[_519],[_503]),
        expect([atom],[_503],[_515]),
        exprtl0([_515],[_519],[_523],[_527],[_531]),
        normalize_result([_576,_578,_580,_582,_584],
                         [_566,_568,_570,_572,_574]).
read__1(_367,_369,_371,_373,_375) :- 
        [atom] = _377, [list,_322] = _379, [_330] = _381, [_334] = _383, [_338] = _385, 
        exprtl0([_322],[atom],[_330],[_334],[_338]),
        normalize_result([_377,_379,_381,_383,_385],
                         [_367,_369,_371,_373,_375]).
read__1(_562,_564,_566,_568,_570) :- 
        [atom] = _572, [_474] = _574, [_519] = _576, [_523] = _578, [_527] = _580, 
        read([_474],[num],[_482],[_499]),
        expect([atom],[_499],[_511]),
        exprtl0([_511],[other],[_519],[_523],[_527]),
        normalize_result([_572,_574,_576,_578,_580],
                         [_562,_564,_566,_568,_570]).
read__1(_363,_365,_367,_369,_371) :- 
        [other] = _373, [_318] = _375, [_326] = _377, [_330] = _379, [_334] = _381, 
        exprtl0([_318],[_322],[_326],[_330],[_334]),
        normalize_result([_373,_375,_377,_379,_381],
                         [_363,_365,_367,_369,_371]).
read__1(_338,_340,_342,_344,_346) :- 
        [_265] = _348, [_312] = _350, [_273] = _352, [_277] = _354, [_281] = _356, 
        syntax_error([list,list,list,list,list,list],[_312]),
        normalize_result([_348,_350,_352,_354,_356],
                         [_338,_340,_342,_344,_346]).
read_args__1(_395,_397,_399) :- 
        [list,_340] = _401, [list,_365] = _403, [_369] = _405, 
        read([_340],[num],[_348],[_361]),
        read_args([_361],[_365],[_369]),
        normalize_result([_401,_403,_405],
                         [_395,_397,_399]).
read_args__1(_159,_161,_163) :- 
        [list,_143] = _165, [list] = _167, [_143] = _169, 
        normalize_result([_165,_167,_169],
                          [_159,_161,_163]).
read_args__1(_282,_284,_286) :- 
        [list,_84] = _288, [_229] = _290, [_233] = _292, 
        syntax_error([list,list,list,list,list],[_260]),
        normalize_result([_288,_290,_292],
                         [_282,_284,_286]).
read_list__1(_395,_397,_399) :- 
        [list,_340] = _401, [list,_365] = _403, [_369] = _405, 
        read([_340],[num],[_348],[_361]),
        read_list([_361],[_365],[_369]),
        normalize_result([_401,_403,_405],
                         [_395,_397,_399]).
read_list__1(_379,_381,_383) :- 
        [list,_324] = _385, [_332] = _387, [_353] = _389, 
        read([_324],[num],[_332],[_349]),
        expect([atom],[_349],[_353]),
        normalize_result([_385,_387,_389],
                         [_379,_381,_383]).
read_list__1(_159,_161,_163) :- 
        [list,_143] = _165, [list] = _167, [_143] = _169, 
        normalize_result([_165,_167,_169],
                          [_159,_161,_163]).
read_list__1(_270,_272,_274) :- 
        [_248] = _276, [_217] = _278, [_221] = _280, 
        syntax_error([list,list,list,list,list],[_248]),
        normalize_result([_276,_278,_280],
                         [_270,_272,_274]).
after_prefix_op__1(_487,_489,_491,_493,_495,_497,_499) :- 
        [_373] = _501, [_425] = _503, [_381] = _505, [_454] = _507, [_416] = _509, [_393] = _511, [_397] = _513, 
        'my <'([_416],[_425]),
        syntax_error([list,list,list,list,list,list,list,list,list],[_454]),
        normalize_result([_501,_503,_505,_507,_509,_511,_513],
                         [_487,_489,_491,_493,_495,_497,_499]).
after_prefix_op__1(_584,_586,_588,_590,_592,_594,_596) :- 
        [_532] = _598, [_528] = _600, [_467] = _602, [_502] = _604, [_536] = _606, [_540] = _608, [_544] = _610, 
        peepop([_502],[_524]),
        prefix_is_atom([_524],[_528]),
        exprtl([_524],[_528],[_532],[_536],[_540],[_544]),
        normalize_result([_598,_600,_602,_604,_606,_608,_610],
                         [_584,_586,_588,_590,_592,_594,_596]).
peepop__1(_166,_168) :- 
        [list,list,_92] = _170, [list,list,_92] = _172, 
        normalize_result([_170,_172],
                          [_166,_168]).
peepop__1(_281,_283) :- 
        [list,_84] = _285, [list,_84] = _287, 
        infixop([_247],[_251],[_255],[_259]),
        normalize_result([_285,_287],
                         [_281,_283]).
peepop__1(_254,_256) :- 
        [list,_84] = _258, [list,_84] = _260, 
        postfixop([_225],[_229],[_233]),
        normalize_result([_258,_260],
                         [_254,_256]).
peepop__1(_126,_128) :- 
        [_113] = _130, [_113] = _132, 
        normalize_result([_130,_132],
                          [_126,_128]).
prefix_is_atom__1(_217,_219) :- 
        [list,_84] = _221, [_197] = _223, 
        prefix_is_atom([_193],[_197]),
        normalize_result([_221,_223],
                         [_217,_219]).
prefix_is_atom__1(_196,_198) :- 
        [other] = _200, [_174] = _202, 
        'my >='([_165],[_174]),
        normalize_result([_200,_202],
                         [_196,_198]).
prefix_is_atom__1(_196,_198) :- 
        [other] = _200, [_174] = _202, 
        'my >='([_165],[_174]),
        normalize_result([_200,_202],
                         [_196,_198]).
prefix_is_atom__1(_122,_124) :- 
        [atom] = _126, [_109] = _128, 
        normalize_result([_126,_128],
                          [_122,_124]).
prefix_is_atom__1(_122,_124) :- 
        [atom] = _126, [_109] = _128, 
        normalize_result([_126,_128],
                          [_122,_124]).
prefix_is_atom__1(_122,_124) :- 
        [atom] = _126, [_109] = _128, 
        normalize_result([_126,_128],
                          [_122,_124]).
prefix_is_atom__1(_190,_192) :- 
        [atom] = _194, [_168] = _196, 
        'my >='([num],[_168]),
        normalize_result([_194,_196],
                         [_190,_192]).
prefix_is_atom__1(_190,_192) :- 
        [atom] = _194, [_168] = _196, 
        'my >='([num],[_168]),
        normalize_result([_194,_196],
                         [_190,_192]).
prefix_is_atom__1(_122,_124) :- 
        [list] = _126, [_109] = _128, 
        normalize_result([_126,_128],
                          [_122,_124]).
exprtl0__1(_586,_588,_590,_592,_594) :- 
        [list,_84] = _596, [_541] = _598, [_545] = _600, [_549] = _602, [_553] = _604, 
        ambigop([_500],[_504],[_508],[_512],[_516],[_520]),
        exprtl([list,_84],[num],[_541],[_545],[_549],[_553]),
        normalize_result([_596,_598,_600,_602,_604],
                         [_586,_588,_590,_592,_594]).
exprtl0__1(_586,_588,_590,_592,_594) :- 
        [list,_84] = _596, [_541] = _598, [_545] = _600, [_549] = _602, [_553] = _604, 
        ambigop([_500],[_504],[_508],[_512],[_516],[_520]),
        exprtl([list,_84],[num],[_541],[_545],[_549],[_553]),
        normalize_result([_596,_598,_600,_602,_604],
                         [_586,_588,_590,_592,_594]).
exprtl0__1(_532,_534,_536,_538,_540) :- 
        [list,_84] = _542, [_487] = _544, [_491] = _546, [_495] = _548, [_499] = _550, 
        infixop([_456],[_460],[_464],[_468]),
        exprtl([list,_84],[num],[_487],[_491],[_495],[_499]),
        normalize_result([_542,_544,_546,_548,_550],
                         [_532,_534,_536,_538,_540]).
exprtl0__1(_505,_507,_509,_511,_513) :- 
        [list,_84] = _515, [_460] = _517, [_464] = _519, [_468] = _521, [_472] = _523, 
        postfixop([_434],[_438],[_442]),
        exprtl([list,_84],[num],[_460],[_464],[_468],[_472]),
        normalize_result([_515,_517,_519,_521,_523],
                         [_505,_507,_509,_511,_513]).
exprtl0__1(_567,_569,_571,_573,_575) :- 
        [list,_490] = _577, [_443] = _579, [_523] = _581, [_527] = _583, [_531] = _585, 
        'my >='([_523],[num]),
        read([_490],[num],[_498],[_511]),
        exprtl([_511],[num],[other],[_523],[_527],[_531]),
        normalize_result([_577,_579,_581,_583,_585],
                         [_567,_569,_571,_573,_575]).
exprtl0__1(_567,_569,_571,_573,_575) :- 
        [list,_490] = _577, [_443] = _579, [_523] = _581, [_527] = _583, [_531] = _585, 
        'my >='([_523],[num]),
        read([_490],[num],[_498],[_511]),
        exprtl([_511],[num],[other],[_523],[_527],[_531]),
        normalize_result([_577,_579,_581,_583,_585],
                         [_567,_569,_571,_573,_575]).
exprtl0__1(_408,_410,_412,_414,_416) :- 
        [list,_84] = _418, [_327] = _420, [_331] = _422, [_335] = _424, [_339] = _426, 
        cant_follow_expr([_356],[_360]),
        syntax_error([list,list,list,list],[list,_84]),
        normalize_result([_418,_420,_422,_424,_426],
                         [_408,_410,_412,_414,_416]).
exprtl0__1(_211,_213,_215,_217,_219) :- 
        [_189] = _221, [_185] = _223, [_181] = _225, [_185] = _227, [_189] = _229, 
        normalize_result([_221,_223,_225,_227,_229],
                          [_211,_213,_215,_217,_219]).
cant_follow_expr__1(_116,_118) :- 
        [other] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [other] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [other] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [other] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [atom] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [atom] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [atom] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
cant_follow_expr__1(_116,_118) :- 
        [atom] = _120, [atom] = _122, 
        normalize_result([_120,_122],
                          [_116,_118]).
exprtl__1(_653,_655,_657,_659,_661,_663) :- 
        [list,_571] = _665, [_553] = _667, [_505] = _669, [_604] = _671, [_608] = _673, [_612] = _675, 
        'my >='([_604],[num]),
        'my <'([_553],[num]),
        read([_571],[num],[_579],[_592]),
        exprtl([_592],[num],[other],[_604],[_608],[_612]),
        normalize_result([_665,_667,_669,_671,_673,_675],
                         [_653,_655,_657,_659,_661,_663]).
exprtl__1(_653,_655,_657,_659,_661,_663) :- 
        [list,_571] = _665, [_553] = _667, [_505] = _669, [_604] = _671, [_608] = _673, [_612] = _675, 
        'my >='([_604],[num]),
        'my <'([_553],[num]),
        read([_571],[num],[_579],[_592]),
        exprtl([_592],[num],[other],[_604],[_608],[_612]),
        normalize_result([_665,_667,_669,_671,_673,_675],
                         [_653,_655,_657,_659,_661,_663]).
exprtl__1(_240,_242,_244,_246,_248,_250) :- 
        [_215] = _252, [_199] = _254, [_211] = _256, [_207] = _258, [_211] = _260, [_215] = _262, 
        normalize_result([_252,_254,_256,_258,_260,_262],
                          [_240,_242,_244,_246,_248,_250]).
syntax_error__1(_150,_152) :- 
        [_119] = _154, [_123] = _156, 
        fail,
        normalize_result([_154,_156],
                         [_150,_152]).

%---------------- Definitions of tabled preds --------------

:- table syntax_error__1/2.
:- table exprtl__1/6.
:- table cant_follow_expr__1/2.
:- table exprtl0__1/5.
:- table prefix_is_atom__1/2.
:- table peepop__1/2.
:- table after_prefix_op__1/7.
:- table read_list__1/3.
:- table read_args__1/3.
:- table read__1/5.
:- table read__1/4.
:- table ambigop__1/6.
:- table infixop__1/4.
:- table postfixop__1/3.
:- table prefixop__1/3.
:- table expect__1/3.
:- table all_read__1/1.
:- table my_read__1/2.
:- table append__1/3.
:- table read_lookup__1/2.
:- table read_digits__1/5.
:- table read_digits__1/4.
:- table read_integer__1/3.
:- table read_fullstop__1/3.
:- table check_special__1/1.
:- table read_symbol__1/3.
:- table read_name__1/3.
:- table read_solidus__1/2.
:- table read_solidus__1/3.
:- table ttynl__1/0.
:- table ttyput__1/1.
:- table more_string__1/4.
:- table read_string__1/4.
:- table read_string__1/3.
:- table read_after_atom__1/3.
:- table getname__1/1.
:- table read_tokens__1/3.
:- table my_get0__1/1.
:- table display__1/1.
:- table read_tokens__1/2.

syntax_error(_63,_65) :- 
        syntax_error__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
exprtl(_63,_65,_67,_69,_71,_73) :- 
        exprtl__1(_75,_77,_79,_81,_83,_85),
        unify_sets([_63,_65,_67,_69,_71,_73], [_75,_77,_79,_81,_83,_85]).
cant_follow_expr(_63,_65) :- 
        cant_follow_expr__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
exprtl0(_63,_65,_67,_69,_71) :- 
        exprtl0__1(_73,_75,_77,_79,_81),
        unify_sets([_63,_65,_67,_69,_71], [_73,_75,_77,_79,_81]).
prefix_is_atom(_63,_65) :- 
        prefix_is_atom__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
peepop(_63,_65) :- 
        peepop__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
after_prefix_op(_63,_65,_67,_69,_71,_73,_75) :- 
        after_prefix_op__1(_77,_79,_81,_83,_85,_87,_89),
        unify_sets([_63,_65,_67,_69,_71,_73,_75], [_77,_79,_81,_83,_85,_87,_89]).
read_list(_63,_65,_67) :- 
        read_list__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_args(_63,_65,_67) :- 
        read_args__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read(_63,_65,_67,_69,_71) :- 
        read__1(_73,_75,_77,_79,_81),
        unify_sets([_63,_65,_67,_69,_71], [_73,_75,_77,_79,_81]).
read(_63,_65,_67,_69) :- 
        read__1(_71,_73,_75,_77),
        unify_sets([_63,_65,_67,_69], [_71,_73,_75,_77]).
ambigop(_63,_65,_67,_69,_71,_73) :- 
        ambigop__1(_75,_77,_79,_81,_83,_85),
        unify_sets([_63,_65,_67,_69,_71,_73], [_75,_77,_79,_81,_83,_85]).
infixop(_63,_65,_67,_69) :- 
        infixop__1(_71,_73,_75,_77),
        unify_sets([_63,_65,_67,_69], [_71,_73,_75,_77]).
postfixop(_63,_65,_67) :- 
        postfixop__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
prefixop(_63,_65,_67) :- 
        prefixop__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
expect(_63,_65,_67) :- 
        expect__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
all_read(_63) :- 
        all_read__1(_65),
        unify_sets([_63], [_65]).
my_read(_63,_65) :- 
        my_read__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
append(_63,_65,_67) :- 
        append__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_lookup(_63,_65) :- 
        read_lookup__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
read_digits(_63,_65,_67,_69,_71) :- 
        read_digits__1(_73,_75,_77,_79,_81),
        unify_sets([_63,_65,_67,_69,_71], [_73,_75,_77,_79,_81]).
read_digits(_63,_65,_67,_69) :- 
        read_digits__1(_71,_73,_75,_77),
        unify_sets([_63,_65,_67,_69], [_71,_73,_75,_77]).
read_integer(_63,_65,_67) :- 
        read_integer__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_fullstop(_63,_65,_67) :- 
        read_fullstop__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
check_special(_63) :- 
        check_special__1(_65),
        unify_sets([_63], [_65]).
read_symbol(_63,_65,_67) :- 
        read_symbol__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_name(_63,_65,_67) :- 
        read_name__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_solidus(_63,_65) :- 
        read_solidus__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).
read_solidus(_63,_65,_67) :- 
        read_solidus__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
ttynl :- 
        ttynl__1,
        unify_sets([], []).
ttyput(_63) :- 
        ttyput__1(_65),
        unify_sets([_63], [_65]).
more_string(_63,_65,_67,_69) :- 
        more_string__1(_71,_73,_75,_77),
        unify_sets([_63,_65,_67,_69], [_71,_73,_75,_77]).
read_string(_63,_65,_67,_69) :- 
        read_string__1(_71,_73,_75,_77),
        unify_sets([_63,_65,_67,_69], [_71,_73,_75,_77]).
read_string(_63,_65,_67) :- 
        read_string__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
read_after_atom(_63,_65,_67) :- 
        read_after_atom__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
getname(_63) :- 
        getname__1(_65),
        unify_sets([_63], [_65]).
read_tokens(_63,_65,_67) :- 
        read_tokens__1(_69,_71,_73),
        unify_sets([_63,_65,_67], [_69,_71,_73]).
my_get0(_63) :- 
        my_get0__1(_65),
        unify_sets([_63], [_65]).
my_display(_63) :- 
        display__1(_65),
        unify_sets([_63], [_65]).
read_tokens(_63,_65) :- 
        read_tokens__1(_67,_69),
        unify_sets([_63,_65], [_67,_69]).

%---------------- Tp ---------------------------------------

tp :- syntax_error__1(_64,_66), fail.
tp :- exprtl__1(_64,_66,_68,_70,_72,_74), fail.
tp :- cant_follow_expr__1(_64,_66), fail.
tp :- exprtl0__1(_64,_66,_68,_70,_72), fail.
tp :- prefix_is_atom__1(_64,_66), fail.
tp :- peepop__1(_64,_66), fail.
tp :- after_prefix_op__1(_64,_66,_68,_70,_72,_74,_76), fail.
tp :- read_list__1(_64,_66,_68), fail.
tp :- read_args__1(_64,_66,_68), fail.
tp :- read__1(_64,_66,_68,_70,_72), fail.
tp :- read__1(_64,_66,_68,_70), fail.
tp :- ambigop__1(_64,_66,_68,_70,_72,_74), fail.
tp :- infixop__1(_64,_66,_68,_70), fail.
tp :- postfixop__1(_64,_66,_68), fail.
tp :- prefixop__1(_64,_66,_68), fail.
tp :- expect__1(_64,_66,_68), fail.
tp :- all_read__1(_64), fail.
tp :- my_read__1(_64,_66), fail.
tp :- append__1(_64,_66,_68), fail.
tp :- read_lookup__1(_64,_66), fail.
tp :- read_digits__1(_64,_66,_68,_70,_72), fail.
tp :- read_digits__1(_64,_66,_68,_70), fail.
tp :- read_integer__1(_64,_66,_68), fail.
tp :- read_fullstop__1(_64,_66,_68), fail.
tp :- check_special__1(_64), fail.
tp :- read_symbol__1(_64,_66,_68), fail.
tp :- read_name__1(_64,_66,_68), fail.
tp :- read_solidus__1(_64,_66), fail.
tp :- read_solidus__1(_64,_66,_68), fail.
tp :- ttynl__1, fail.
tp :- ttyput__1(_64), fail.
tp :- more_string__1(_64,_66,_68,_70), fail.
tp :- read_string__1(_64,_66,_68,_70), fail.
tp :- read_string__1(_64,_66,_68), fail.
tp :- read_after_atom__1(_64,_66,_68), fail.
tp :- getname__1(_64), fail.
tp :- read_tokens__1(_64,_66,_68), fail.
tp :- my_get0__1(_64), fail.
tp :- display__1(_64), fail.
tp :- read_tokens__1(_64,_66), fail.
tp.


%---------------- Builtin Preds ----------------------------

'my ='(X1,X2) :- 'my =__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my \\=='(X1,X2) :- 'my \\==__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my is'(X1,X2) :- 'my is__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my =:='(X1,X2) :- 'my =:=__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my =\\='(X1,X2) :- 'my =\\=__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my <'(X1,X2) :- 'my <__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my >'(X1,X2) :- 'my >__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my >='(X1,X2) :- 'my >=__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).
'my =<'(X1,X2) :- 'my =<__1'(Y1,Y2), unify_sets([X1,X2],[Y1,Y2]).

'my =__1'(X,X).
'my \\==__1'(_,_).
'my is__1'(num,num).
'my <__1'(num,num).
'my >__1'(num,num).
'my >=__1'(num,num).
'my =<__1'(num,num).
'my =:=__1'(num,num).
'my =\\=__1'(num,num).


%---------------- Show Result ------------------------------

show_facts :- syntax_error__1(_63,_65),
              numbervars([_63,_65]),
              write(syntax_error(_63,_65)), nl, fail.
show_facts :- exprtl__1(_63,_65,_67,_69,_71,_73),
              numbervars([_63,_65,_67,_69,_71,_73]),
              write(exprtl(_63,_65,_67,_69,_71,_73)), nl, fail.
show_facts :- cant_follow_expr__1(_63,_65),
              numbervars([_63,_65]),
              write(cant_follow_expr(_63,_65)), nl, fail.
show_facts :- exprtl0__1(_63,_65,_67,_69,_71),
              numbervars([_63,_65,_67,_69,_71]),
              write(exprtl0(_63,_65,_67,_69,_71)), nl, fail.
show_facts :- prefix_is_atom__1(_63,_65),
              numbervars([_63,_65]),
              write(prefix_is_atom(_63,_65)), nl, fail.
show_facts :- peepop__1(_63,_65),
              numbervars([_63,_65]),
              write(peepop(_63,_65)), nl, fail.
show_facts :- after_prefix_op__1(_63,_65,_67,_69,_71,_73,_75),
              numbervars([_63,_65,_67,_69,_71,_73,_75]),
              write(after_prefix_op(_63,_65,_67,_69,_71,_73,_75)), nl, fail.
show_facts :- read_list__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_list(_63,_65,_67)), nl, fail.
show_facts :- read_args__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_args(_63,_65,_67)), nl, fail.
show_facts :- read__1(_63,_65,_67,_69,_71),
              numbervars([_63,_65,_67,_69,_71]),
              write(read(_63,_65,_67,_69,_71)), nl, fail.
show_facts :- read__1(_63,_65,_67,_69),
              numbervars([_63,_65,_67,_69]),
              write(read(_63,_65,_67,_69)), nl, fail.
show_facts :- ambigop__1(_63,_65,_67,_69,_71,_73),
              numbervars([_63,_65,_67,_69,_71,_73]),
              write(ambigop(_63,_65,_67,_69,_71,_73)), nl, fail.
show_facts :- infixop__1(_63,_65,_67,_69),
              numbervars([_63,_65,_67,_69]),
              write(infixop(_63,_65,_67,_69)), nl, fail.
show_facts :- postfixop__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(postfixop(_63,_65,_67)), nl, fail.
show_facts :- prefixop__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(prefixop(_63,_65,_67)), nl, fail.
show_facts :- expect__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(expect(_63,_65,_67)), nl, fail.
show_facts :- all_read__1(_63),
              numbervars([_63]),
              write(all_read(_63)), nl, fail.
show_facts :- my_read__1(_63,_65),
              numbervars([_63,_65]),
              write(my_read(_63,_65)), nl, fail.
show_facts :- append__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(append(_63,_65,_67)), nl, fail.
show_facts :- read_lookup__1(_63,_65),
              numbervars([_63,_65]),
              write(read_lookup(_63,_65)), nl, fail.
show_facts :- read_digits__1(_63,_65,_67,_69,_71),
              numbervars([_63,_65,_67,_69,_71]),
              write(read_digits(_63,_65,_67,_69,_71)), nl, fail.
show_facts :- read_digits__1(_63,_65,_67,_69),
              numbervars([_63,_65,_67,_69]),
              write(read_digits(_63,_65,_67,_69)), nl, fail.
show_facts :- read_integer__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_integer(_63,_65,_67)), nl, fail.
show_facts :- read_fullstop__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_fullstop(_63,_65,_67)), nl, fail.
show_facts :- check_special__1(_63),
              numbervars([_63]),
              write(check_special(_63)), nl, fail.
show_facts :- read_symbol__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_symbol(_63,_65,_67)), nl, fail.
show_facts :- read_name__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_name(_63,_65,_67)), nl, fail.
show_facts :- read_solidus__1(_63,_65),
              numbervars([_63,_65]),
              write(read_solidus(_63,_65)), nl, fail.
show_facts :- read_solidus__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_solidus(_63,_65,_67)), nl, fail.
show_facts :- ttynl__1,
              numbervars([]),
              write(ttynl), nl, fail.
show_facts :- ttyput__1(_63),
              numbervars([_63]),
              write(ttyput(_63)), nl, fail.
show_facts :- more_string__1(_63,_65,_67,_69),
              numbervars([_63,_65,_67,_69]),
              write(more_string(_63,_65,_67,_69)), nl, fail.
show_facts :- read_string__1(_63,_65,_67,_69),
              numbervars([_63,_65,_67,_69]),
              write(read_string(_63,_65,_67,_69)), nl, fail.
show_facts :- read_string__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_string(_63,_65,_67)), nl, fail.
show_facts :- read_after_atom__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_after_atom(_63,_65,_67)), nl, fail.
show_facts :- getname__1(_63),
              numbervars([_63]),
              write(getname(_63)), nl, fail.
show_facts :- read_tokens__1(_63,_65,_67),
              numbervars([_63,_65,_67]),
              write(read_tokens(_63,_65,_67)), nl, fail.
show_facts :- my_get0__1(_63),
              numbervars([_63]),
              write(my_get0(_63)), nl, fail.
show_facts :- display__1(_63),
              numbervars([_63]),
              write(display(_63)), nl, fail.
show_facts :- read_tokens__1(_63,_65),
              numbervars([_63,_65]),
              write(read_tokens(_63,_65)), nl, fail.
show_facts.
