% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeDependencies.R
\name{mergeDependencies}
\alias{mergeDependencies}
\alias{mergeDependencies,character-method}
\alias{mergeDependencies,Scenario-method}
\alias{mergeDependencies<-}
\alias{mergeDependencies<-,character-method}
\alias{mergeDependencies<-,Scenario-method}
\title{Merge dependencies for a Scenario}
\usage{
mergeDependencies(ssimObject)

\S4method{mergeDependencies}{character}(ssimObject)

\S4method{mergeDependencies}{Scenario}(ssimObject)

mergeDependencies(ssimObject) <- value

\S4method{mergeDependencies}{character}(ssimObject) <- value

\S4method{mergeDependencies}{Scenario}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}} object}

\item{value}{logical. If \code{TRUE} the Scenario will be set to merge
dependencies at run time. Default is \code{FALSE}}
}
\value{
A logical: \code{TRUE} if the scenario is configured to merge dependencies at run time,
and \code{FALSE} otherwise.
}
\description{
Retrieves or sets whether or not a \code{\link{Scenario}} is configured to
merge dependencies at run time.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Retrieve whether or not dependencies will be merged for a Scenario
mergeDependencies(myScenario)

# Set whether or not dependencies will be merged for a Scenario
mergeDependencies(myScenario) <- TRUE
}

}
