% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filepath.R
\name{filepath}
\alias{filepath}
\alias{filepath,character-method}
\alias{filepath,Session-method}
\alias{filepath,SsimObject-method}
\alias{filepath,Folder-method}
\title{Retrieves the path to a SyncroSim object on disk}
\usage{
filepath(ssimObject)

\S4method{filepath}{character}(ssimObject)

\S4method{filepath}{Session}(ssimObject)

\S4method{filepath}{SsimObject}(ssimObject)

\S4method{filepath}{Folder}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{Session}}, \code{\link{Project}},
\code{\link{SsimLibrary}}, or \code{\link{Folder}} object}
}
\value{
A character string: the path to a SyncroSim object on disk.
}
\description{
Retrieves the path to a SyncroSim \code{\link{Session}},
\code{\link{SsimLibrary}}, \code{\link{Project}}, \code{\link{Scenario}},
of \code{\link{Folder}} on disk.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Get the file path
myFilePath <- filepath(myLibrary)
}

}
