% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartErrorBar.R
\name{chartErrorBar}
\alias{chartErrorBar}
\alias{chartErrorBar,Chart-method}
\title{Modify the error bars of a \code{\link{Chart}}}
\usage{
chartErrorBar(chart, type = NULL, lower = NULL, upper = NULL)

\S4method{chartErrorBar}{Chart}(chart, type = NULL, lower = NULL, upper = NULL)
}
\arguments{
\item{chart}{\code{\link{Chart}} object}

\item{type}{character. Type of error bar. Values can be "percentile",
"minmax", or "none". Default is NULL.}

\item{lower}{float. If the error bar type is set to "percentile", then
sets the minimum percentile for the lower range of the error bar. Default is
\code{NULL}.}

\item{upper}{float. If the error bar type is set to "percentile", then
sets the maximum percentile for the upper range of the error bar. Default is
\code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart error
bar settings.
}
\description{
Set the type and properties of the error bars of a \code{\link{Chart}}.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Set the chart error bars to display the minimum/maximum of the data
myChart <- chartErrorBar(myChart, type = "minmax")

# Disable the chart error bars
myChart <- chartErrorBar(myChart, type = "none")

# Set the chart error bars to display the 95th percentile error bars
myChart <- chartErrorBar(myChart, type = "percentile", lower = 2.5, 
                         upper = 97.5)
}

}
