% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\name{do_base_split}
\alias{do_base_split}
\title{Apply Basic Split (For Use In Custom Split Functions)}
\usage{
do_base_split(spl, df, vals = NULL, labels = NULL, trim = FALSE)
}
\arguments{
\item{spl}{A Split object defining a partitioning or analysis/tabulation of
the data.}

\item{df}{dataset (\code{data.frame} or \code{tibble})}

\item{vals}{ANY. Already calculated/known values of the split. Generally
should be left as \code{NULL}.}

\item{labels}{character. Labels associated with \code{vals}. Should be
\code{NULL} when \code{vals} is, which should almost always be the case.}

\item{trim}{logical(1). Should groups corresponding to empty data subsets be
removed. Defaults to \code{FALSE}.}
}
\value{
the result of the split being applied as if it had no custom split
function, see \code{\link{custom_split_funs}}
}
\description{
This function is intended for use inside custom split functions. It applies
the current split \emph{as if it had no custom splitting function} so that
those default splits can be further manipulated.
}
\examples{

uneven_splfun <- function(df, spl, vals = NULL, labels = NULL, trim = FALSE) {
    ret <- do_base_split(spl, df, vals, labels, trim)
    if(NROW(df) == 0)
        ret <- lapply(ret, function(x) x[1])
    ret
}

lyt <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_cols_by_multivar(c("USUBJID", "AESEQ", "BMRKR1"),
                           varlabels = c("N", "E", "BMR1"),
                           split_fun = uneven_splfun) \%>\%
    analyze_colvars(list(USUBJID = function(x, ...) length(unique(x)),
                         AESEQ = max,
                         BMRKR1 = mean))

tbl <- build_table(lyt, subset(ex_adae, as.numeric(ARM) <= 2))
tbl
}
