% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_rows_by}
\alias{split_rows_by}
\title{Add Rows according to levels of a variable}
\usage{
split_rows_by(
  lyt,
  var,
  labels_var = var,
  split_label = var,
  split_fun = NULL,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  label_pos = "hidden",
  indent_mod = 0L,
  page_by = FALSE,
  page_prefix = split_label,
  section_div = NA_character_
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{var}{string, variable name}

\item{labels_var}{string, name of variable containing labels to be displayed
for the values of \code{var}}

\item{split_label}{string. Label string to be associated with the table
generated by the split. Not to be confused with labels assigned to each
child (which are based on the data and type of split during tabulation).}

\item{split_fun}{function/NULL. custom splitting function See
\code{\link{custom_split_funs}}}

\item{format}{\code{FormatSpec}. Format associated with this split. Formats can be
declared via strings (\code{"xx.x"}) or function. In cases such as
\code{analyze} calls, they can character vectors or lists of functions.}

\item{na_str}{character(1). String that should be displayed when the value of \code{x} is missing.
Defaults to \code{"NA"}.}

\item{nested}{boolean. Should this layout instruction be applied within the
existing layout structure \emph{if possible} (\code{TRUE}, the default) or as a
new top-level element (`FALSE). Ignored if it would nest a split underneath
analyses, which is not allowed.}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"},
\code{"hidden"}. What should the display behavior be for the  labels (i.e.
label rows) of the children of this split. Defaults to \code{"default"}
which flags the label row as visible only if the child has 0 content rows.}

\item{label_pos}{character(1). Location the variable label should be
displayed, Accepts \code{"hidden"} (default for non-analyze row splits), \code{"visible"},
\code{"topleft"}, and - for analyze splits only - \code{"default"}.  For analyze calls,
\code{"default"} indicates that the variable should be visible if and only if
multiple variables are analyzed at the same level of nesting.}

\item{indent_mod}{numeric. Modifier for the default indent position for the
structure created by this function(subtable, content table, or row)
\emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{page_by}{logical(1). Should pagination be forced between different
children resulting form this split. An error will rise if the selected split
does not contain at least one value that is not \code{NA}.}

\item{page_prefix}{character(1). Prefix, to be appended with the split value,
when forcing pagination between the children of this split/table}

\item{section_div}{character(1). String which should be repeated as a section
divider after each group defined by this split instruction, or
\code{NA_character_} (the default) for no section divider.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further
layouting functions, and to \code{build_table}.
}
\description{
Add Rows according to levels of a variable
}
\note{
If \code{var} is a factor with empty unobserved levels and
\code{labels_var} is specified, it must also be a factor
with the same number of levels as \code{var}. Currently the
error that occurs when this is not the case is not very informative,
but that will change in the future.
}
\section{Custom Splitting Function Details}{


User-defined custom split functions can perform any type of computation on
the incoming data provided that they meet the contract for generating
'splits' of the incoming data 'based on' the split object.

Split functions are functions that accept:
\describe{
\item{df}{data.frame of incoming data to be split}
\item{spl}{a Split object. this is largely an internal detail custom
functions will not need to worry about, but  \code{obj_name(spl)}, for
example, will give the name of the split as it will appear in paths in the
resulting table}
\item{vals}{Any pre-calculated values. If given non-null values, the values
returned should match these. Should be NULL in most cases and can likely be
ignored}
\item{labels}{Any pre-calculated value labels. Same as above for
\code{values}}
\item{trim}{If \code{TRUE}, resulting splits that are empty should be
removed}
\item{(Optional) .spl_context}{a data.frame describing previously performed
splits which collectively arrived at \code{df}}
}

The function must then output a \code{named list} with the following
elements:

\describe{
\item{values}{The vector of all values corresponding to the splits of
\code{df}}
\item{datasplit}{a list of data.frames representing the groupings of the
actual observations from \code{df}.}
\item{labels}{a character vector giving a string label for each value listed
in the \code{values} element above}
\item{(Optional) extras}{If present, extra arguments are to be passed to summary
and analysis functions whenever they are executed on the corresponding
element of \code{datasplit} or a subset thereof}
}

One way to generate custom splitting functions is to wrap existing split
functions and modify either the incoming data before they are called or
their outputs.
}

\examples{

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("RACE", split_fun = drop_split_levels) \%>\%
  analyze("AGE", mean, var_labels = "Age", format = "xx.xx")

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("RACE") \%>\%
  analyze("AGE", mean, var_labels = "Age", format = "xx.xx")

tbl2 <- build_table(lyt2, DM)
tbl2

lyt3 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  summarize_row_groups(label_fstr = "Overall (N)") \%>\%
  split_rows_by("RACE",
    split_label = "Ethnicity", labels_var = "ethn_lab",
    split_fun = drop_split_levels
  ) \%>\%
  summarize_row_groups("RACE", label_fstr = "\%s (n)") \%>\%
  analyze("AGE", var_labels = "Age", afun = mean, format = "xx.xx")

lyt3

library(dplyr)
DM2 <- DM \%>\%
  filter(SEX \%in\% c("M", "F")) \%>\%
  mutate(
    SEX = droplevels(SEX),
    gender_lab = c(
      "F" = "Female", "M" = "Male",
      "U" = "Unknown",
      "UNDIFFERENTIATED" = "Undifferentiated"
    )[SEX],
    ethn_lab = c(
      "ASIAN" = "Asian",
      "BLACK OR AFRICAN AMERICAN" = "Black or African American",
      "WHITE" = "White",
      "AMERICAN INDIAN OR ALASKA NATIVE" = "American Indian or Alaska Native",
      "MULTIPLE" = "Multiple",
      "NATIVE HAWAIIAN OR OTHER PACIFIC ISLANDER" =
        "Native Hawaiian or Other Pacific Islander",
      "OTHER" = "Other", "UNKNOWN" = "Unknown"
    )[RACE]
  )

tbl3 <- build_table(lyt3, DM2)
tbl3

}
\author{
Gabriel Becker
}
