% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{ElementaryTable-class}
\alias{ElementaryTable-class}
\alias{ElementaryTable}
\alias{TableTree-class}
\alias{TableTree}
\title{\code{TableTree} classes}
\usage{
ElementaryTable(
  kids = list(),
  name = "",
  lev = 1L,
  label = "",
  labelrow = LabelRow(lev = lev, label = label, vis = !isTRUE(iscontent) && !is.na(label)
    && nzchar(label)),
  rspans = data.frame(),
  cinfo = NULL,
  iscontent = NA,
  var = NA_character_,
  format = NULL,
  na_str = NA_character_,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  header_section_div = NA_character_,
  hsep = default_hsep(),
  trailing_section_div = NA_character_,
  inset = 0L
)

TableTree(
  kids = list(),
  name = if (!is.na(var)) var else "",
  cont = EmptyElTable,
  lev = 1L,
  label = name,
  labelrow = LabelRow(lev = lev, label = label, vis = nrow(cont) == 0 && !is.na(label) &&
    nzchar(label)),
  rspans = data.frame(),
  iscontent = NA,
  var = NA_character_,
  cinfo = NULL,
  format = NULL,
  na_str = NA_character_,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  page_title = NA_character_,
  hsep = default_hsep(),
  header_section_div = NA_character_,
  trailing_section_div = NA_character_,
  inset = 0L
)
}
\arguments{
\item{kids}{list. List of direct children.}

\item{name}{character(1). Name of the split/table/row being created. Defaults
to same as the corresponding label, but is not required to be.}

\item{lev}{integer. Nesting level (roughly, indentation level in practical
terms).}

\item{label}{character(1). A label (not to be confused with the name) for the
object/structure.}

\item{labelrow}{\code{LabelRow}. The \code{LabelRow} object to assign to this Table.
Constructed from \code{label} by default if not specified.}

\item{rspans}{data.frame. Currently stored but otherwise ignored.}

\item{cinfo}{\code{InstantiatedColumnInfo} (or NULL). Column structure for the
object being created.}

\item{iscontent}{logical. Is the \code{TableTree}/\code{ElementaryTable} being constructed
the content table for another \code{TableTree}.}

\item{var}{string, variable name}

\item{format}{\code{FormatSpec}. Format associated with this split. Formats can be
declared via strings (\code{"xx.x"}) or function. In cases such as
\code{analyze} calls, they can character vectors or lists of functions.}

\item{na_str}{character(1). String that should be displayed when the value of \code{x} is missing.
Defaults to \code{"NA"}.}

\item{indent_mod}{numeric. Modifier for the default indent position for the
structure created by this function(subtable, content table, or row)
\emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{title}{character(1). Main title (\code{\link[=main_title]{main_title()}}) is a single string.
Ignored for subtables.}

\item{subtitles}{character. Subtitles (\code{\link[=subtitles]{subtitles()}}) can be vector of strings, where
every element is printed in a separate line. Ignored for subtables.}

\item{main_footer}{character. Main global (non-referential) footer materials
(\code{\link[=main_footer]{main_footer()}}). If it is a vector of strings, they will be printed on separate
lines.}

\item{prov_footer}{character. Provenance-related global footer materials
(\code{\link[=prov_footer]{prov_footer()}}). It can be also a vector of strings, printed on different lines.
Generally should not be modified by hand.}

\item{header_section_div}{character(1). String which will be used to divide the header
from the table. See \code{\link[=header_section_div]{header_section_div()}} for getter and setter of these.
Please consider changing last element of \code{\link[=section_div]{section_div()}} when concatenating
tables that need a divider between them.}

\item{hsep}{character(1). Set of character(s) to be repeated as the separator
between the header and body of the table when rendered as text. Defaults to
a connected horizontal line (unicode 2014) in locals that use a UTF
charset, and to \code{-} elsewhere (with a once per session warning). See
\code{\link[formatters:default_horizontal_sep]{formatters::set_default_hsep()}} for further information.}

\item{trailing_section_div}{character(1). String which will be used as a section
divider after the printing of the last row contained in this (sub)-table,
unless that row is also the last table row to be printed overall, or
\code{NA_character_} for none (the default). When generated via layouting, this
would correspond to the \code{section_div} of the split under which this table
represents a single facet.}

\item{inset}{numeric(1). Number of spaces to inset the table header, table
body, referential footnotes, and main_footer, as compared to alignment
of title, subtitle, and provenance footer. Defaults to 0 (no inset).}

\item{cont}{\code{ElementaryTable}. Content table.}

\item{page_title}{character. Page specific title(s).}
}
\value{
A formal object representing a populated table.
}
\description{
\code{TableTree} classes

Table Constructors and Classes
}
\author{
Gabriel Becker
}
