% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{spl_context}
\alias{spl_context}
\title{.spl_context within analysis and split functions}
\description{
\code{.spl_context} is an optional parameter for any of rtables' special functions, i.e. \code{afun} (analysis function
in \code{\link[=analyze]{analyze()}}), \code{cfun} (content or label function in \code{\link[=summarize_row_groups]{summarize_row_groups()}}), or \code{split_fun} (e.g. for
\code{\link[=split_rows_by]{split_rows_by()}}).
}
\details{
The \code{.spl_context} \code{data.frame} gives information about the subsets of data corresponding to the splits within
which the current \code{analyze} action is nested. Taken together, these correspond to the path that the resulting (set
of) rows the analysis function is creating, although the information is in a slightly different form. Each split
(which correspond to groups of rows in the resulting table), as well as the initial 'root' "split", is represented
via the following columns:

\describe{
\item{split}{The name of the split (often the variable being split).}
\item{value}{The string representation of the value at that split (\code{split}).}
\item{full_parent_df}{A \code{data.frame} containing the full data (i.e. across all columns) corresponding to the path
defined by the combination of \code{split} and \code{value} of this row \emph{and all rows above this row}.}
\item{all_cols_n}{The number of observations corresponding to the row grouping (union of all columns).}
\item{column for each column in the table structure (\emph{row-split and analyze contexts only})}{These list columns
(named the same as \code{names(col_exprs(tab))}) contain logical vectors corresponding to the subset of this row's
\code{full_parent_df} corresponding to the column.}
\item{cur_col_id}{Identifier of the current column. This may be an internal name, constructed by pasting the
column path together.}
\item{cur_col_subset}{List column containing logical vectors indicating the subset of this row's \code{full_parent_df}
for the column currently being created by the analysis function.}
\item{cur_col_expr}{List of current column expression. This may be used to filter \code{.alt_df_row}, or any external
data, by column. Filtering \code{.alt_df_row} by columns produces \code{.alt_df}.}
\item{cur_col_n}{Integer column containing the observation counts for that split.}
\item{cur_col_split}{Current column split names. This is recovered from the current column path.}
\item{cur_col_split_val}{Current column split values. This is recovered from the current column path.}
}
}
\note{
Within analysis functions that accept \code{.spl_context}, the \code{all_cols_n} and \code{cur_col_n} columns of the data frame
will contain the 'true' observation counts corresponding to the row-group and row-group x column subsets of the
data. These numbers will not, and currently cannot, reflect alternate column observation counts provided by the
\code{alt_counts_df}, \code{col_counts} or \code{col_total} arguments to \code{\link[=build_table]{build_table()}}.
}
