% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_article.R
\name{acs_article}
\alias{acs_article}
\title{American Chemical Society (ACS) Journal format.}
\usage{
acs_article(..., keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"), fig_caption = TRUE)
}
\arguments{
\item{...}{Arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{fig_caption}{\code{TRUE} to render figures with captions}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{render}}
}
\description{
Format for creating an American Chemical Society (ACS) Journal articles.
Adapted from
\href{http://pubs.acs.org/page/4authors/submission/tex.html}{http://pubs.acs.org/page/4authors/submission/tex.html}.
}
\examples{

\dontrun{
library(rmarkdown)
draft("MyArticle.Rmd", template = "acs_article", package = "rticles")
}

}
