% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_index.R
\name{index}
\alias{index}
\title{Extract time-indices from trim output}
\usage{
index(x, which = c("imputed", "fitted", "both"), covars = FALSE, base = 1)
}
\arguments{
\item{x}{an object of class \code{\link{trim}}}

\item{which}{\code{[character]} Selector to distinguish between time indices based on the imputed data (default),
the fitted model, or both.}

\item{covars}{\code{[logical]} Switch to compute indices for covariate categories as well.}

\item{base}{\code{[integer|numeric]} Base time point, for which the index is 1. If the data contains J time points,
the base time point can be given in the interval 1...J, or,
if the time points are proper years, say year1...yearn, the base year can be given.
So, if the data range 2000...2016, \code{base=2} and \code{base=2001} are equivalent.}
}
\value{
A data frame containing indices and their uncertainty expressed as
  standard error. Depending on the chosen output, columns \code{fitted}
  and \code{se_fit}, and/or \code{imputed} and \code{se_imp} are present.
  If \code{covars} is \code{TRUE}, additional indices are computed for the
  individual covariate categories. In this case additional columns
  \code{covariate} and \code{category} are present. The overall indices are
  marked as covariate `Overall' and category 0.
}
\description{
Extract time-indices from trim output
}
\examples{

data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2)
index(z)
# mimic classic TRIM:
index(z, "both")
# Extract standard errors for the imputed data
SE <- index(z,"imputed")$se_mod
# Include covariates
z <- trim(count ~ site + time + Habitat, data=skylark, model=2)
ind <- index(z, covars=TRUE)
plot(ind)
}
\seealso{
Other analyses: \code{\link{coef.trim}}, \code{\link{gof}},
  \code{\link{now_what}}, \code{\link{overall}},
  \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}

