% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{summary.trim}
\alias{summary.trim}
\title{Summary information for a TRIM job}
\usage{
\method{summary}{trim}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{trim}}.}

\item{...}{Currently unused}
}
\value{
A \code{list} of class \code{trim.summary} containing the call that
  created the object, the model code, the coefficients (in additive and
  multiplicative form) , the goodness of fit parameters,the overdispersion
  and the serial correlation parameters (if computed).
}
\description{
Print a summary of a \code{\link{trim}} object.
}
\examples{

data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2, overdisp=TRUE)

summary(z)
}
\seealso{
\code{\link{trim}}

Other analyses: \code{\link{coef.trim}}, \code{\link{gof}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}

