% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{confint.trim}
\alias{confint.trim}
\title{Compute time-totals confidence interval}
\usage{
\method{confint}{trim}(object, parm = c("imputed", "fitted"), level = 0.95,
  ...)
}
\arguments{
\item{object}{a TRIM output object}

\item{parm}{parameter specification: imputed or fitted time-totals.}

\item{level}{the confidence level required.}

\item{...}{not used [included for R compatibility reasons]}
}
\description{
Computes confidence intervals for the time-totals of a TRIM model.
Both imputed and fitted time-totals are supported, and the confidence level can be specified.
}
\examples{
data(skylark2)
z <- trim(count ~ site + year, data=skylark2, model=3)
CI <- confint(z)
}
\seealso{
Other analyses: \code{\link{coef.trim}}, \code{\link{gof}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}
