% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_embed.R
\name{tweet_embed}
\alias{tweet_embed}
\title{Create a Tweet Embed}
\usage{
tweet_embed(screen_name, status_id, ...)
}
\arguments{
\item{screen_name}{character, screen name of the user}

\item{status_id}{character, status id}

\item{...}{parameters to pass to the GET call. See
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/get-statuses-oembed}
for details.}
}
\value{
character
}
\description{
Twitter API GET call to retieve the tweet in embedded form.
}
\examples{
name   <- 'kearneymw'
status <- '1087047171306856451'

tweet_embed(screen_name = name, status_id = status)

tweet_embed(
 screen_name = name,
 status_id = status,
 hide_thread = TRUE, 
 hide_media = FALSE, 
 align = 'center'
)

}
\seealso{
\code{\link[httr:GET]{httr::GET()}},\code{\link[httr:content]{httr::content()}}
}
