% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-all-the-things.R
\name{starspace_dictionary}
\alias{starspace_dictionary}
\title{Get the dictionary of a Starspace model}
\usage{
starspace_dictionary(object)
}
\arguments{
\item{object}{an object of class \code{textspace} as returned by \code{\link{starspace}} or \code{\link{starspace_load_model}}}
}
\value{
a list with elements 
\enumerate{
\item{ntokens: }{The number of tokens in the data}
\item{nwords: }{The number of words which are part of the dictionary}
\item{nlabels: }{The number of labels which are part of the dictionary}
\item{labels: }{A character vector with the labels}
\item{dictionary_size: }{The size of the dictionary (nwords + nlabels)}
\item{dictionary: }{A data.frame with all the words and labels from the dictionary. This data.frame has columns term, is_word and is_label indicating
for each term if it is a word or a label}
}
}
\description{
Get the dictionary of a Starspace model
}
\examples{
data(dekamer, package = "ruimtehol")
dekamer <- subset(dekamer, depotdat < as.Date("2017-02-01"))
dekamer$text <- strsplit(dekamer$question, "\\\\W")
dekamer$text <- lapply(dekamer$text, FUN = function(x) x[x != ""])
dekamer$text <- sapply(dekamer$text, 
                       FUN = function(x) paste(x, collapse = " "))
dekamer$question_theme_main <- gsub(" ", "-", dekamer$question_theme_main)

set.seed(123456789)
model <- embed_tagspace(x = tolower(dekamer$text), 
                        y = dekamer$question_theme_main, 
                        early_stopping = 0.8, 
                        dim = 10, minCount = 5)
dict <- starspace_dictionary(model)
str(dict)
}
