% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_long_run_vol_no_skew}
\alias{DAGM_long_run_vol_no_skew}
\title{DAGM (daily) long-run volatility (no skewness)}
\usage{
DAGM_long_run_vol_no_skew(param, daily_ret, mv_m, K)
}
\arguments{
\item{param}{Vector of estimated values. It must be a seven- or eight- dimensional vector. See the examples below.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}
}
\value{
The resulting vector is an "xts" object representing the conditional volatility.
}
\description{
Obtains the daily long-run volatility for the DAGM, without the asymmetric term linked to past negative returns.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
# est_val<-c(0.01,0.80,0,0.1,1.1,-0.3,1.1)
# r_t<-sp500['/2010']
# mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
# head(DAGM_long_run_vol_no_skew(est_val,r_t,mv_m,K=12))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
