% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-file.R
\name{download_file}
\alias{download_file}
\title{Download}
\usage{
download_file(
  url,
  dir = tempdir(),
  fname = basename(urltools::path(url)),
  overwrite = FALSE,
  mode = "wb",
  ...
)
}
\arguments{
\item{url}{URL of file to be downloaded.}

\item{dir}{Directory where to download the file.}

\item{fname}{Base name of the downloaded file (\code{dir} will be prefixed).}

\item{overwrite}{Whether to overwrite? Default is \code{FALSE}.}

\item{mode}{See parameter of \code{\link[=download.file]{download.file()}}.
Default of "wb" seems useful for Windows systems.}

\item{...}{
  Arguments passed on to \code{\link[utils:download.file]{utils::download.file}}
  \describe{
    \item{\code{method}}{Method to be used for downloading files.  Current
    download methods are \code{"internal"}, \code{"wininet"} (Windows
    only) \code{"libcurl"}, \code{"wget"} and \code{"curl"}, and there
    is a value \code{"auto"}: see \sQuote{Details} and \sQuote{Note}.

    The method can also be set through the option
    \code{"download.file.method"}: see \code{\link{options}()}.
  }
    \item{\code{quiet}}{If \code{TRUE}, suppress status messages (if any), and
    the progress bar.}
    \item{\code{cacheOK}}{logical.  Is a server-side cached value acceptable?}
    \item{\code{extra}}{character vector of additional command-line arguments for
    the \code{"wget"} and \code{"curl"} methods.}
    \item{\code{headers}}{named character vector of HTTP headers to use in HTTP
    requests.  It is ignored for non-HTTP URLs.  The \code{User-Agent}
    header, coming from the \code{HTTPUserAgent} option (see
    \code{\link{options}}) is used as the first header, automatically.}
  }}
}
\value{
Path to the downloaded (or existing) file.
}
\description{
Download file if does not exist yet.
}
\examples{
download_file("https://github.com/privefl.png")
download_file("https://github.com/privefl.png")
download_file("https://github.com/privefl.png", overwrite = TRUE)

}
