% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_func.R
\name{RunningCor}
\alias{RunningCor}
\title{Fast Running Correlation Computation}
\usage{
RunningCor(x, y, circular = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector, of equal or shorter length than  \code{x}.}

\item{circular}{logical; whether  running correlation is computed assuming
circular nature of  \code{x} time-series (see Details).}
}
\value{
A numeric vector.
}
\description{
Computes running correlation between time-series \code{x} and short-time pattern  \code{y}.
}
\details{
Computes running correlation between time-series \code{x} and short-time pattern  \code{y}.
The length of output vector equals the length of \code{x}.
Parameter \code{circular} determines whether \code{x} time-series is assumed to have a  circular nature.
Assume \eqn{l_x} is the length of time-series \code{x}, \eqn{l_y} is the length of short-time pattern \code{y}.

If \code{circular} equals \code{TRUE} then
  \itemize{
    \item first element of the output vector corresponds to sample correlation between \code{x[1:l_y]} and \code{y},
    \item last element of the output vector corresponds to sample correlation between \code{c(x[l_x], x[1:(l_y - 1)])}  and \code{y}.
  }

If \code{circular} equals \code{FALSE} then
  \itemize{
    \item first element of the output vector corresponds to sample correlation between \code{x[1:l_y]} and \code{y},
    \item the \eqn{l_x - W + 1}-th element of the output vector corresponds to sample correlation between \code{x[(l_x - l_y + 1):l_x]},
    \item last \code{W-1} elements of the output vector are filled with \code{NA}.
  }

See \code{runstats.demo(func.name = "RunningCor")} for a detailed presentation.
}
\examples{
x <- sin(seq(0, 1, length.out = 1000) * 2 * pi * 6)
y <- x[1:100]
out1 <- RunningCor(x, y, circular = TRUE)
out2 <- RunningCor(x, y, circular = FALSE)
plot(out1, type = "l"); points(out2, col = "red")

}
