% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Tinkoff.R
\name{getSymbols.Tinkoff}
\alias{getSymbols.Tinkoff}
\title{Get earnings data from investing.com}
\usage{
getSymbols.Tinkoff(
  Symbols,
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  api.key = NULL,
  period = "day",
  market = NULL,
  verbose = FALSE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{A character vector with the names of the symbols to be retrieved.}

\item{from}{A character string representing the start date for the financial data, in the format "YYYY-MM-DD". By default, it is "2007-01-01".}

\item{to}{A character string representing the end date for the financial data, in the format "YYYY-MM-DD". By default, it is the current system date.}

\item{adjust}{A logical value indicating whether to adjust prices for dividends and stock splits. By default, it is FALSE.}

\item{api.key}{A character string containing the API key for accessing Tinkoff API.}

\item{period}{A character string representing the interval of time between two candles. By default it is "day".}

\item{market}{A character string representing the market to which the symbol belongs. By default, it is NULL.}

\item{verbose}{A logical value indicating whether to print verbose output. By default, it is FALSE.}

\item{auto.assign}{A logical value indicating whether to automatically assign the downloaded data to an object with the same name as the symbol. By default, it is FALSE.}

\item{...}{Additional arguments.}
}
\value{
A data table with the financial data for the specified symbol(s).
}
\description{
Retrieve financial data from Tinkoff API.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.Tinkoff("BBG004730N88",from=Sys.Date()-5, ap.key = "your_api_key",verbose=TRUE)
}
\author{
Vyacheslav Arbuzov
}
