% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dweibull_rvec}
\alias{dweibull_rvec}
\alias{pweibull_rvec}
\alias{qweibull_rvec}
\alias{rweibull_rvec}
\title{Weibull Distribution, Using Multiple Draws}
\usage{
dweibull_rvec(x, shape, scale = 1, log = FALSE)

pweibull_rvec(q, shape, scale = 1, lower.tail = TRUE, log.p = FALSE)

qweibull_rvec(p, shape, scale = 1, lower.tail = TRUE, log.p = FALSE)

rweibull_rvec(n, shape, scale = 1, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{shape}{Shape parameter. See \code{\link[stats:Weibull]{stats::dweibull()}}.
Can be an rvec.}

\item{scale}{Scale parameter. See \code{\link[stats:Weibull]{stats::dweibull()}}
Default is \code{1}. Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
Weibull distribution, modified to work with
rvecs.
}
\details{
Functions \code{dweibull_rvec()}, \code{pweibull_rvec()},
\code{pweibull_rvec()} and \code{rweibull_rvec()} work like
base R functions \code{\link[=dt]{dt()}}, \code{\link[=pt]{pt()}},
\code{\link[=qt]{qt()}}, and \code{\link[=rt]{rt()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rweibull_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dweibull_rvec()}, \code{pweibull_rvec()},
\code{pweibull_rvec()} and \code{rweibull_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3.2, 4.5),
               c(7.6, 0.7)))
dweibull_rvec(x, shape = 2)
pweibull_rvec(x, shape = 2)

rweibull_rvec(n = 2,
              shape = c(2, 3),
              n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dweibull]{dweibull()}}
\item \code{\link[=pweibull]{pweibull()}}
\item \code{\link[=qweibull]{qweibull()}}
\item \code{\link[=rweibull]{rweibull()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
