% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{vinecop_distributions}
\alias{vinecop_distributions}
\alias{dvinecop}
\alias{pvinecop}
\alias{rvinecop}
\alias{dvinecop_dist}
\alias{pvinecop_dist}
\alias{rvinecop_dist}
\alias{pvinecop}
\alias{rvinecop}
\title{Vine copula distributions}
\usage{
dvinecop(u, vinecop)

pvinecop(u, vinecop, n_mc = 10^4)

rvinecop(n, vinecop, U = NULL)
}
\arguments{
\item{u}{evaluation points, either a length d vector or a d-column matrix,
where d is the number of variables in the vine.}

\item{vinecop}{an object of class \code{"vinecop_dist"}.}

\item{n_mc}{number of samples used for quasi Monte Carlo integration.}

\item{n}{number of observations.}

\item{U}{optionally, an \eqn{n \times d} matrix of values in \eqn{(0,1)}.
The result is then the inverse Rosenblatt transform of \code{U}; if \code{U} is a
matrix of independent \eqn{U(0, 1)} variables, this simulates data
from \code{vinecop}.}
}
\value{
\code{dvinecop()} gives the density, \code{pvinecop()} gives the distribution function,
and \code{rvinecop()} generates random deviates.

The length of the result is determined by \code{n} for \code{rvinecop()}, and
the number of rows in \code{u} for the other functions.

The \code{vinecop} object is recycled to the length of the
result.
}
\description{
Density, distribution function and random generation
for the vine copula distribution.
}
\details{
See \link{vinecop} for the estimation and construction of vine copula models.
Here, the density, distribution function and random generation
for the vine copulas are standard.

The Rosenblatt transform (Rosenblatt, 1952) \eqn{U = T(V)} of a random vector
\eqn{V = (V_1,\ldots,V_d) ~ C} is defined as
\deqn{ 
  U_1 = V_1, U_2 = C(V_2|V_1), \ldots, U_d =C(V_d|V_1,\ldots,V_{d-1}), 
}
where \eqn{C(v_k|v_1,\ldots,v_{k-1})} is the conditional distribution of
\eqn{V_k} given \eqn{V_1 \ldots, V_{k-1}, k = 2,\ldots,d}. The vector \eqn{V}
are then independent standard uniform variables. The inverse operation
\deqn{ 
  V_1 = U_1, V_2 = C^{-1}(U_2|U_1), \ldots, V_d =C^{-1}(U_d|U_1,\ldots,U_{d-1}), 
}
can can be used to simulate from a copula. For any copula \eqn{C}, if
\eqn{U} is a vector of independent random variables, \eqn{V = T^{-1}(U)} has
distribution \eqn{C}.
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
    list(bicop, bicop),  # pair-copulas in first tree 
    list(bicop)          # pair-copulas in second tree 
 )
 
# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3) 

# set up vine copula model
vc <- vinecop_dist(pcs, mat)

# simulate from the model
u <- rvinecop(200, vc)
pairs(u)

# evaluate the density and cdf
dvinecop(u[1, ], vc)
pvinecop(u[1, ], vc)

# get single pair copula
get_pair_copula(vc, 1, 1)

# get all pair copulas
get_all_pair_copulas(vc)

# get vine matrix
get_matrix(vc)

# extract a truncated sub-vine based on truncation level supplied by user
truncate_model(vc, 1)

}
