% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_model.R
\name{truncate_model}
\alias{truncate_model}
\alias{truncate_model.rvine_structure}
\alias{truncate_model.rvine_matrix}
\alias{truncate_model.vinecop_dist}
\alias{truncate_model.vine_dist}
\title{Truncate a vine copula model}
\usage{
truncate_model(object, ...)

\method{truncate_model}{rvine_structure}(object, trunc_lvl, ...)

\method{truncate_model}{rvine_matrix}(object, trunc_lvl, ...)

\method{truncate_model}{vinecop_dist}(object, trunc_lvl, ...)

\method{truncate_model}{vine_dist}(object, trunc_lvl, ...)
}
\arguments{
\item{object}{a model object.}

\item{...}{further arguments passed to specific methods.}

\item{trunc_lvl}{tree level after which the vine copula should be truncated.}
}
\description{
Extracts a truncated sub-vine based on a truncation level supplied by user.
}
\details{
While a vine model for a \code{d} dimensional random vector contains at most \code{d-1}
nested trees, this function extracts a sub-model based on a given truncation
level.

For instance, \code{truncate_model(object, 1)} results in a 1-truncated
vine (i.e., a vine with a single tree). Similarly \code{truncate_model(object, 2)}
results in a 2-truncated vine (i.e., a vine with two trees). Note that
\code{truncate_model(truncate_model(object, 1), 2)} returns a 1-truncated vine.
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
    list(bicop, bicop),  # pair-copulas in first tree 
    list(bicop)          # pair-copulas in second tree 
)

# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3)

# set up vine structure
structure <- as_rvine_structure(mat)

# truncate the model
truncate_model(structure, 1)

# set up vine copula model
vc <- vinecop_dist(pcs, mat)

# truncate the model
truncate_model(vc, 1)
}
