% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop.R
\name{bicop}
\alias{bicop}
\title{Fit and select bivariate copula models}
\usage{
bicop(
  data,
  var_types = c("c", "c"),
  family_set = "all",
  par_method = "mle",
  nonpar_method = "quadratic",
  mult = 1,
  selcrit = "bic",
  weights = numeric(),
  psi0 = 0.9,
  presel = TRUE,
  keep_data = FALSE,
  cores = 1
)
}
\arguments{
\item{data}{a matrix or data.frame with at least two columns, containing the
(pseudo-)observations for the two variables (copula data should have
approximately uniform margins). More columns are required for discrete
models, see \emph{Details}.}

\item{var_types}{variable types, a length 2 vector; e.g., \code{c("c", "c")} for
both continuous (default), or \code{c("c", "d")} for first variable continuous
and second discrete.}

\item{family_set}{a character vector of families; see \emph{Details} for
additional options.}

\item{par_method}{the estimation method for parametric models, either \code{"mle"}
for maximum likelihood or \code{"itau"} for inversion of Kendall's tau (only
available for one-parameter families and \code{"t"}.}

\item{nonpar_method}{the estimation method for nonparametric models, either
\code{"constant"} for the standard transformation estimator, or
\code{"linear"}/\code{"quadratic"} for the local-likelihood approximations of order
one/two.}

\item{mult}{multiplier for the smoothing parameters of nonparametric
families. Values larger than 1 make the estimate more smooth, values less
than 1 less smooth.}

\item{selcrit}{criterion for family selection, either \code{"loglik"}, \code{"aic"},
\code{"bic"}, \code{"mbic"}. For \code{vinecop()} there is the additional option
\code{"mbicv"}.}

\item{weights}{optional vector of weights for each observation.}

\item{psi0}{see \code{\link[=mBICV]{mBICV()}}.}

\item{presel}{whether the family set should be thinned out according to
symmetry characteristics of the data.}

\item{keep_data}{whether the data should be stored (necessary for using
\code{\link[=fitted]{fitted()}}).}

\item{cores}{number of cores to use; if more than 1, estimation for multiple
families is done in parallel.}
}
\value{
An object inheriting from classes \code{bicop} and  \code{bicop_dist} . In addition to
the entries contained in \code{bicop_dist()}, objects from the \code{bicop} class
contain:
\itemize{
\item \code{data} (optionally, if \code{keep_data = TRUE} was used), the dataset that was
passed to \code{\link[=bicop]{bicop()}}.
\item \code{controls}, a \code{list} with the set of fit controls that was passed to
\code{\link[=bicop]{bicop()}}.
\item \code{loglik} the log-likelihood.
\item \code{nobs}, an \code{integer} with the number of observations that was used to fit
the model.
}
}
\description{
Fit a bivariate copula model for continuous or discrete data. The family
can be selected automatically from a vector of options.
}
\details{
\subsection{Discrete variables}{

When at least one variable is discrete, more than two columns are required
for \code{data}: the first \eqn{n \times 2} block contains realizations of
\eqn{F_{X_1}(x_1), F_{X_2}(x_2)}. The second \eqn{n \times 2} block contains
realizations of \eqn{F_{X_1}(x_1^-), F_{X_1}(x_1^-)}. The minus indicates a
left-sided limit of the cdf. For, e.g., an integer-valued variable, it holds
\eqn{F_{X_1}(x_1^-) = F_{X_1}(x_1 - 1)}. For continuous variables the left
limit and the cdf itself coincide. Respective columns can be omitted in the
second block.
}

\subsection{Family collections}{

The \code{family_set} argument accepts all families in \code{bicop_dist()} plus the
following convenience definitions:
\itemize{
\item \code{"all"} contains all the families,
\item \code{"parametric"} contains the parametric families (all except \code{"tll"}),
\item \code{"nonparametric"} contains the nonparametric families (\code{"indep"} and
\code{"tll"})
\item \code{"onepar"} contains the parametric families with a single parameter,
}

(\code{"gaussian"}, \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, and \code{"joe"}),
\itemize{
\item \code{"twopar"} contains the parametric families with two parameters
(\code{"student"}, \code{"bb1"}, \code{"bb6"}, \code{"bb7"}, and \code{"bb8"}),
\item \code{"elliptical"} contains the elliptical families,
\item \code{"archimedean"} contains the archimedean families,
\item \code{"BB"} contains the BB families,
\item \code{"itau"} families for which estimation by Kendall's tau inversion is
available (\code{"indep"},\code{"gaussian"}, \code{"student"},\code{"clayton"}, \code{"gumbel"},
\code{"frank"}, \code{"joe"}).
}
}
}
\examples{
## fitting a continuous model from simulated data
u <- rbicop(100, "clayton", 90, 3)
fit <- bicop(u, family_set = "par")
summary(fit)

## compare fit with true model
contour(fit)
contour(bicop_dist("clayton", 90, 3), col = 2, add = TRUE)

## fit a model from discrete data
x_disc <- qpois(u, 1)  # transform to Poisson margins
plot(x_disc)
udisc <- cbind(ppois(x_disc, 1), ppois(x_disc - 1, 1))
fit_disc <- bicop(udisc, var_types = c("d", "d"))
summary(fit_disc)
}
\seealso{
\code{\link[=bicop_dist]{bicop_dist()}}, \code{\link[=plot.bicop]{plot.bicop()}}, \code{\link[=contour.bicop]{contour.bicop()}}, \code{\link[=dbicop]{dbicop()}},
\code{\link[=pbicop]{pbicop()}}, \code{\link[=hbicop]{hbicop()}}, \code{\link[=rbicop]{rbicop()}}
}
