% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err-sim.R
\name{rxCombineErrorLines}
\alias{rxCombineErrorLines}
\title{Combine Error Lines and create rxode2 expression}
\usage{
rxCombineErrorLines(
  uiModel,
  errLines = NULL,
  prefixLines = NULL,
  paramsLine = NULL,
  modelVars = FALSE,
  cmtLines = TRUE,
  dvidLine = TRUE,
  lstExpr = NULL,
  useIf = TRUE
)
}
\arguments{
\item{uiModel}{UI model}

\item{errLines}{Error lines; If missing, get the error lines from
\code{rxGetDistributionSimulationLines()}}

\item{prefixLines}{Prefix lines, after param statement}

\item{paramsLine}{Params line, if not present.}

\item{modelVars}{Return model vars instead of rxode2 statement}

\item{cmtLines}{Include trailing \code{cmt} lines}

\item{dvidLine}{Include trailing \code{dvid()} specification}

\item{lstExpr}{A list of expressions for model, or NULL.  When NULL
defaults to the model expressions accessible by
\code{uiModel$lstExpr}.}

\item{useIf}{Use an \verb{if (CMT == X)} for endpoints}
}
\value{
quoted expression that can be evaluated to compiled rxode2
model
}
\description{
Combine Error Lines and create rxode2 expression
}
\details{
This is exported to allow other functions to mangle the error lines
to make other types of estimation methods (if needed)
}
\examples{

\donttest{

one.cmt <- function() {
   ini({
     ## You may label each parameter with a comment
     tka <- 0.45 # Log Ka
     tcl <- log(c(0, 2.7, 100)) # Log Cl
     ## This works with interactive models
     ## You may also label the preceding line with label("label text")
     tv <- 3.45; label("log V")
     ## the label("Label name") works with all models
     eta.ka ~ 0.6
     eta.cl ~ 0.3
     eta.v ~ 0.1
     add.sd <- 0.7
   })
   model({
     ka <- exp(tka + eta.ka)
     cl <- exp(tcl + eta.cl)
     v <- exp(tv + eta.v)
     linCmt() ~ add(add.sd)
   })
}

f <- rxode2(one.cmt)

# You can get the simulation model easily by
rxCombineErrorLines(f)

# You can then get the compiled model by simply evaluting the model:
r <- eval(rxCombineErrorLines(f))

# This also works with multile endpoint models:
pk.turnover.emax <- function() {
  ini({
    tktr <- log(1)
    tka <- log(1)
    tcl <- log(0.1)
    tv <- log(10)
    ##
    eta.ktr ~ 1
    eta.ka ~ 1
    eta.cl ~ 2
    eta.v ~ 1
    prop.err <- 0.1
    pkadd.err <- 0.1
    ##
    temax <- logit(0.8)
    tec50 <- log(0.5)
    tkout <- log(0.05)
    te0 <- log(100)
    ##
    eta.emax ~ .5
    eta.ec50  ~ .5
    eta.kout ~ .5
    eta.e0 ~ .5
    ##
    pdadd.err <- 10
  })
  model({
    ktr <- exp(tktr + eta.ktr)
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    ##
    emax=expit(temax+eta.emax)
    ec50 =  exp(tec50 + eta.ec50)
    kout = exp(tkout + eta.kout)
    e0 = exp(te0 + eta.e0)
    ##
    DCP = center/v
    PD=1-emax*DCP/(ec50+DCP)
    ##
    effect(0) = e0
    kin = e0*kout
    ##
    d/dt(depot) = -ktr * depot
    d/dt(gut) =  ktr * depot -ka * gut
    d/dt(center) =  ka * gut - cl / v * center
    d/dt(effect) = kin*PD -kout*effect
    ##
    cp = center / v
    cp ~ prop(prop.err) + add(pkadd.err)
    effect ~ add(pdadd.err)
  })
}

f <- rxode2(pk.turnover.emax)
rxCombineErrorLines(f)

# Note that in the parsed form, you can also get the compiled rxode2
# model with $simulationModel

f$simulationModel

}
}
\author{
Matthew L. Fidler
}
\keyword{internal}
