% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxStack.R
\name{rxStack}
\alias{rxStack}
\title{Stack a solved object for things like default ggplot2 plot}
\usage{
rxStack(data, vars = NULL, doSim = TRUE)
}
\arguments{
\item{data}{is a rxode2 object to be stacked.}

\item{vars}{Variables to include in stacked data; By default this
is all the variables when vars is NULL.

When vars is \code{sim} and comes from a \code{rxode2} ui simulation with
multiple endpoints (ie it has a \code{CMT} in the simulation), it will
rework the data as if it was stacked based the value based on the
compartments in the multiple endpoint model.

When the vars is \code{sim.endpoint1} it will subset the stack to
endpoint1, you can also have `c("sim.endpoint1", "sim.endpoint2")
and the "stack" will subset to endpoint1 and endpoint2.

When you specify the \code{sim} type variables they have to be all
prefixed with \code{sim} otherwise, the stack will not treat them
differently.}

\item{doSim}{boolean that determines if the "sim" variable in a
\code{rxSolve} dataset is actually "stacking" based on the endpoint
(\code{TRUE}) or simply treating \code{sim} as a variable.}
}
\value{
Stacked data with \code{value} and \code{trt}, where value is the values
and \code{trt} is the state and \code{lhs} variables.
}
\description{
Stack a solved object for things like default ggplot2 plot
}
\author{
Matthew Fidler
}
