% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection_xgboost.R
\name{projection_xgboost}
\alias{projection_xgboost}
\title{Projection Estimator}
\usage{
projection_xgboost(
  target_col,
  data_model,
  data_proj,
  id,
  STRATA = NULL,
  domain1,
  domain2,
  weight,
  task_type,
  test_size = 0.2,
  nfold = 5,
  corrected_bias = FALSE
)
}
\arguments{
\item{target_col}{The name of the column that contains the target variable in the \code{data_model}.}

\item{data_model}{A data frame or a data frame extension (e.g., a tibble) representing the training dataset, which consists of auxiliary variables and the target variable. This dataset is characterized by a smaller sample size and provides information on both the variable of interest and the auxiliary variables.}

\item{data_proj}{A data frame or a data frame extension (e.g., a tibble) representing the projection dataset, which is characterized by a larger sample size that collects only auxiliary information or general-purpose variables. This dataset must contain the same auxiliary variables as the \code{data_model} and is used for making predictions based on the trained model.}

\item{id}{Column name specifying cluster ids from the largest level to the smallest level, where ~0 or ~1 represents a formula indicating the absence of clusters.}

\item{STRATA}{The name of the column that specifies the strata; set to NULL if no stratification is required.#' @param test_size Proportion of data used for training (default is 0.8, meaning 80\% for training and 20\% for validation).}

\item{domain1}{Domain variables for higher-level survey estimation. (e.g., "province")}

\item{domain2}{Domain variables for more granular survey estimation at a lower administrative level. (e.g., "regency")}

\item{weight}{The name of the column in \code{data_proj} that represents the survey weight, usually used for the purpose of indirect estimation .}

\item{task_type}{A string that specifies the modeling objective, indicating whether the task is for classification or regression.
Use "classification" for tasks where the goal is to categorize data into discrete classes, such as predicting whether an email is spam or not.
Use "regression" for tasks where the goal is to predict a continuous outcome, such as forecasting sales revenue or predicting house prices.}

\item{test_size}{The proportion of data used for testing, with the remaining data used for training.}

\item{nfold}{The number of data partitions used for cross-validation (n-fold validation).}

\item{corrected_bias}{A logical value indicating whether to apply bias correction to the estimation results from the modeling process.
When set to TRUE, this parameter ensures that the estimates are adjusted to account for any systematic biases, leading to more accurate and reliable predictions.}
}
\value{
The function returns a list containing:
\code{params_used} The hyperparameters and settings of the trained model used for projection.
\code{nfeatures} The number of features selected and used in the trained model for projection.
\code{domain1_estimation} Projected estimation results for each domain 1, example province, including :
\itemize{
\item \code{Estimation} Estimated values.
\item \code{RSE} Relative Standard Error.
\item \code{var} Variance of the estimation.
}
\code{domain2_estimation} Projected estimation results for each domain2, example regency (kabupaten/kota), including :
\itemize{
\item \code{Estimation} Estimated values.
\item \code{RSE} Relative Standard Error.
\item \code{var} Variance of the estimation.
}

If \code{task_type} is \code{"classification"}:
\code{mean_train_accuracy} Mean training accuracy.
\code{final_accuracy} Final model accuracy on the test data.
\code{confusion_matrix} Confusion matrix of the classification model.

If \code{task_type} is \code{"regression"}:
\code{mean_train_rmse} Mean training RMSE.
\code{final_rmse} Final RMSE on the test data.

If \code{corrected_bias} is \code{TRUE}:
\code{direct_estimation} Direct estimation before bias correction.
\code{koreksi_bias_domain1} Bias-corrected estimation for provinces.
\code{koreksi_bias_domain2} Bias-corrected estimation for regencies.
}
\description{
\strong{Kim and Rao (2012)}, proposed a model-assisted projection estimation method for two independent surveys, where the first survey  (\strong{A1}) has a large sample that only collects auxiliary variables, while the second survey (\strong{A1}) has a smaller sample but contains information on both the focal variable and auxiliary variables.
This method uses a \strong{Working Model (WM)} to relate the focal variable to the auxiliary variable based on data from  \strong{A2}, and then predicts the value of the focal variable for \strong{A1}. A projection estimator is then obtained from the (\strong{A2}) sample using the resulting synthetic values.
This approach produces estimators that are asymptotically unbiased and can improve the efficiency of domain estimation, especially when the sample size in survey 1 is much larger compared to survey 2.

This function applies the XGBoost algorithm to project estimated values from a small survey onto an independent larger survey.
While the two surveys are statistically independent, the projection is based on common auxiliary variables.
The process in this function involves data preprocessing, feature selection, getting the best model with hyperparameter tuning, and performing domain-specific estimation following survey design principles.
}
\examples{
\donttest{
library(xgboost)
library(caret)
library(FSelector)
library(glmnet)
library(recipes)

Data_A <- df_survey_A
Data_B <- df_survey_B

hasil <- projection_xgboost(
                            target_col = "Y",
                            data_model = Data_A,
                            data_proj = Data_B,
                            id = "psu+ssu",
                            STRATA = "strata",
                            domain1 = "province",
                            domain2 = "regency",
                            weight = "weight",
                            task_type = "classification")
}
}
\references{
\enumerate{
\item Kim, J. K., & Rao, J. N. (2012). Combining data from two independent surveys: a model-assisted approach. Biometrika, 99(1), 85-100.
\item Kim and Rao (2012), the synthetic data obtained through the model-assisted projection method can provide a useful tool for efficient domain estimation when the size of the sample in survey 1 is much larger than the size of sample in survey 2.
}
}
