#' @title Sample Data for Small Area Estimation with Measurement Error using Hierarchical Bayesian Method under Beta Distribution
#' @description This data generated by simulation based on Hierarchical Bayesian Method under Normal Distribution with Measurement Error by following these steps:
#' \enumerate{
#'   \item Generate \eqn{x_{1}}{x1} ~ UNIF(0, 1), \eqn{x_{2}}{\x2} ~ UNIF(0, 1), \eqn{x_{3}}{x3} ~ UNIF(0, 1), and \eqn{x_{4}}{x4} ~ UNIF(0, 1)
#'   \item Generate \eqn{v.x_{1}}{v.x1} ~ Gamma(2,1) and \eqn{v.x_{2}}{v.x2} ~ Gamma(2,5)
#'   \item Generate \eqn{x_{1h}}{x1h} ~ N(\eqn{x_{1}}{x1}, sqrt(\eqn{v.x_{1}}{v.x1})) and \eqn{x_{2h}}{x2h} ~ N(\eqn{x_{2}}{x2}, sqrt(\eqn{v.x_{2}}{v.x2}))
#'   \item Set Coefficient \eqn{\beta_{0}}{\beta0} = \eqn{\beta_{1}}{\beta1} = \eqn{\beta_{2}}{\beta2} = \eqn{\beta_{3}}{\beta3} = \eqn{\beta_{4}}{\beta4} = \eqn{{0,5}}
#'   \item Generate \eqn{u}{u} ~ N(0,1) and \eqn{\pi}{\pi} ~ Gamma(1,0.5)
#'   \item Calculate \deqn{{\mu} =\frac{\beta_{0} + \beta_{1}*x_{1h} + \beta_{2}*x_{2h} + \beta_{3}*x_{3} + \beta_{4}*x_{4} + u}{\beta0 + \beta1*x1h + \beta2*x2h + \beta3*x3 + \beta4*x4 + u}}
#'   \item Calculate \eqn{A}{A} = \eqn{\mu}{\mu}\eqn{\pi}{\pi} and \eqn{B}{B} = (1-\eqn{\mu})\eqn{\pi}
#'   \item Generate \eqn{Y}{Y} ~ UNIF(A,B)
#'   \item Calculate Mean of Variable Y with \deqn{{E(Y)}=\frac{A}{A+B}}
#'   \item Calculate Variance of Variable Y with \deqn{{Var(Y)} =  \frac{AB}{ (A+B+1)(A+B)^2}}
#' }
#' Direct estimation \code{Y}, auxiliary variables \code{x1 x2 x3 x4}, sampling variance \code{v}, and mean squared error of auxiliary variables \code{v.x1 v.x2} are arranged in a dataframe called \code{dataHBMEbeta}.
#' @usage data(dataHBMEbeta)
#' @format A data frame with 30 rows and 8 variables:
#' \describe{
#'   \item{\code{Y}}{direct estimation of Y.}
#'   \item{\code{x1}}{auxiliary variable of x1.}
#'   \item{\code{x2}}{auxiliary variable of x2.}
#'   \item{\code{x3}}{auxiliary variable of x3.}
#'   \item{\code{x4}}{auxiliary variable of x4.}
#'   \item{\code{vardir}}{sampling variances of Y.}
#'   \item{\code{v.x1}}{mean squared error of x1.}
#'   \item{\code{v.x2}}{mean squared error of x2.}
#'}
#'@name dataHBMEbeta
NULL
