% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial.R
\name{Binomial}
\alias{Binomial}
\title{Small Area Estimation using Hierarchical Bayesian under Binomial Distribution}
\usage{
Binomial(
  formula,
  n.samp,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{n.samp}{number of sample}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method, if there is non sampled area, then the result of estimation of mu in nonsampled areas are the probabilites}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Binomial Distribution using Logit normal model. The data is an accumulation from the Bernoulli process which there are exactly two mutually exclusive outcomes of a case.
}
\examples{
\donttest{
#Data Generation
set.seed(123)
m=30
x1=runif(m,0,1)
x2=runif(m,0,1)
b0=b1=b2=0.5
u=rnorm(m,0,1)
n.samp1=round(runif(m,10,30))
mu= exp(b0 + b1*x1+b2*x2+u)/(1+exp(b0 + b1*x1+b2*x2+u))
y=rbinom(m,n.samp1,mu)
vardir=n.samp1*mu*(1-mu)
dataBinomial=as.data.frame(cbind(y,x1,x2,n.samp=n.samp1,vardir))
dataBinomialNs = dataBinomial
dataBinomialNs$y[c(3,14,22,29,30)] <- NA
dataBinomialNs$vardir[c(3,14,22,29,30)] <- NA
dataBinomialNs$n.samp[c(3,14,22,29,30)] <- NA


#Compute Fitted Model
#y~x1+x2


## For data without any nonsampled area
formula = y~x1+x2
n.s = "n.samp"
vc = c(1,1,1)
c = c(0,0,0)
dat = dataBinomial


# Using parameter coef and var.coef
saeHBBinomial<-Binomial(formula,n.samp=n.s,coef=c,var.coef=vc,iter.update=10,data =dat)
#This example use only 10 observations to make the example execution time be faster

saeHBBinomial$Est                                 #Small Area mean Estimates
saeHBBinomial$refVar                              #Random effect variance
saeHBBinomial$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBBinomial$plot[[3]]) is used to generate ACF Plot
#plot(saeHBBinomial$plot[[3]]) is used to generate Density and trace plot

# Do not using parameter coef and var.coef
saeHBBinomial <- Binomial(formula,n.samp ="n.samp",data=dataBinomial)



## For data with nonsampled area use dataBinomialNs

}
}
\author{
Azka Ubaidillah [aut], Ika Yuni Wulansari [aut], Zaza Yuda Perwira [aut, cre], Jayanti Wulansari [aut, cre], Fauzan Rais Arfizain [aut,cre]
}
