% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{checkDoubleArgumentsDesignObject}
\alias{checkDoubleArgumentsDesignObject}
\title{Helper function to check whether arguments are specified in a function at a higher level and already
provided in the design object.}
\usage{
checkDoubleArgumentsDesignObject(designObj, ...)
}
\arguments{
\item{designObj}{an object of class "safeDesign".}

\item{...}{arguments that need checking.}
}
\value{
Returns nothing only used for its side-effects to produces warnings if needed.
}
\description{
Helper function to check whether arguments are specified in a function at a higher level and already
provided in the design object.
}
\examples{
designObj <- designSafeZ(0.4)

checkDoubleArgumentsDesignObject(designObj, "alpha"=NULL, alternative=NULL)
# Throws a warning
checkDoubleArgumentsDesignObject(designObj, "alpha"=0.4, alternative="d")
}
