% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{computeNPlanBatchSafeZ}
\alias{computeNPlanBatchSafeZ}
\title{Helper function: Computes the planned sample size based on the minimal clinical relevant mean
difference, alpha and beta.}
\usage{
computeNPlanBatchSafeZ(
  meanDiffMin,
  alpha = 0.05,
  beta = 0.2,
  sigma = 1,
  kappa = sigma,
  alternative = c("two.sided", "greater", "less"),
  testType = c("oneSample", "paired", "twoSample"),
  tol = 1e-05,
  highN = 1e+06,
  ratio = 1,
  parameter = NULL,
  grow = TRUE
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{tol}{a number that defines the stepsizes between the lowParam and highParam.}

\item{highN}{integer that defines the largest n of our search space for n. This might be the
largest n that we are able to fund.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{grow}{logical, default set to \code{TRUE} so the grow safe test is used in the design.}
}
\value{
a list which contains at least nPlan and the phiS, that is, the parameter that defines
the safe test.
}
\description{
Helper function: Computes the planned sample size based on the minimal clinical relevant mean
difference, alpha and beta.
}
