% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{gendataPaper}
\alias{gendataPaper}
\title{Simulation Scenario from Bhatnagar et al. (2018+) sail paper}
\usage{
gendataPaper(n, p, corr = 0, E = truncnorm::rtruncnorm(n, a = -1, b =
  1), betaE = 2, SNR = 2, hierarchy = c("strong", "weak", "none"),
  nonlinear = TRUE, interactions = TRUE, causal, not_causal)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of main effect variables (X)}

\item{corr}{correlation between predictors}

\item{E}{simulated environment vector of length \code{n}. Can be continuous
or integer valued. Factors must be converted to numeric. Default:
\code{truncnorm::rtruncnorm(n, a = -1, b = 1)}}

\item{betaE}{exposure effect size}

\item{SNR}{signal to noise ratio}

\item{hierarchy}{type of hierarchy. Can be one of \code{c("strong", "weak",
"none")}. Default: "strong"}

\item{nonlinear}{simulate non-linear terms (logical). Default: TRUE}

\item{interactions}{simulate interaction (logical). Default: TRUE}

\item{causal}{character vector of causal variable names}

\item{not_causal}{character vector of noise variables}
}
\value{
A list with the following elements: \describe{ \item{x}{matrix of
  dimension \code{nxp} of simulated main effects} \item{y}{simulated response
  vector of length \code{n}} \item{e}{simulated exposure vector of length
  \code{n}} \item{Y.star}{linear predictor vector of length \code{n}}
  \item{f1}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f2}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f3}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f4}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{betaE}{the value for \eqn{\beta_E}} \item{f1.f}{the function
  \code{f1}} \item{f2.f}{the function \code{f2}} \item{f3.f}{the function
  \code{f3}} \item{f4.f}{the function \code{f4}} \item{X1}{an \code{n} length
  vector of the first predictor} \item{X2}{an \code{n} length vector of the
  second predictor} \item{X3}{an \code{n} length vector of the third
  predictor} \item{X4}{an \code{n} length vector of the fourth predictor}
  \item{scenario}{a character representing the simulation scenario identifier
  as described in Bhatnagar et al. (2018+)} \item{causal}{character vector of
  causal variable names}\item{not_causal}{character vector of noise
  variables} }
}
\description{
generates the different simulation scenarios. This function is
  not intended to be called directly by users. See \code{\link{gendata}}
}
\details{
Requires installation of \code{truncnorm} package. Not meant to be
  called directly by user. Use \code{\link{gendata}}.
}
\seealso{
\code{\link[stats]{rnorm}},\code{\link[stats]{cor}},
  \code{\link{gendata}}
}
