% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_get_all_jobs_bulk}
\alias{sf_get_all_jobs_bulk}
\title{Get All Bulk API Jobs}
\usage{
sf_get_all_jobs_bulk(next_records_url = NULL, api_type = c("Bulk 2.0"),
  verbose = FALSE)
}
\arguments{
\item{next_records_url}{character (leave as NULL); a string used internally 
by the function to paginate through to more records until complete}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} of parameters defining the details of all bulk jobs
}
\description{
This function retrieves details about all Bulk 2.0 jobs in the org.
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
all_jobs_info <- sf_get_all_jobs_bulk()
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_bulk_v2.meta/api_bulk_v2/get_all_jobs.htm}
}
