% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_create_job_bulk_v1}
\alias{sf_create_job_bulk_v1}
\title{Create Job using Bulk 1.0 API}
\usage{
sf_create_job_bulk_v1(
  operation = c("insert", "delete", "upsert", "update", "hardDelete", "query",
    "queryall"),
  object_name,
  external_id_fieldname = NULL,
  content_type = c("CSV", "ZIP_CSV", "ZIP_XML", "ZIP_JSON"),
  concurrency_mode = c("Parallel", "Serial"),
  control,
  ...,
  verbose = FALSE
)
}
\arguments{
\item{operation}{\code{character}; a string defining the type of operation being
performed (e.g. "insert", "update", "upsert", "delete", "hardDelete",
"query", "queryall").}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{external_id_fieldname}{\code{character}; string identifying a custom field on the
object that has been set as an "External ID" field. This field is used to reference
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{content_type}{\code{character}; a string indicating the format for
the API request and response. Must be one of 'CSV', 'ZIP_CSV', 'ZIP_XML', or
'ZIP_JSON'.}

\item{concurrency_mode}{\code{character}; a string indicating whether the batches
should be processed in parallel or serially (sequentially). Serial processing
is helpful when multiple records may trigger simultaneous edits to another
related record (e.g., updating multiple children all on the same account).}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df}; a data frame containing information about the job created.
}
\description{
Create Job using Bulk 1.0 API
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
