% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_all}
\alias{calc_all}
\title{Diagnostics Wrapper}
\usage{
calc_all(chain, plot = TRUE, acf.alpha = 0.05, acf.lag.max = 100)
}
\arguments{
\item{chain}{Vector of n length, where n is the number of trials or sampler iterations}

\item{plot}{Boolean. Whether to additionally plot the diagnostics.}

\item{acf.alpha, acf.lag.max}{Additional parameters to \link[samplr]{calc_autocorr}.}
}
\value{
A list with all diagnostic calculations (a list of lists); and optionally a grid of plots.
}
\description{
Calculates all diagnostic functions in the samplr package for a given chain. Optionally, plots them.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
diagnostics <- calc_all(chain1[[1]])
names(diagnostics)
}
