% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectHMMR.R
\name{selectHMMR}
\alias{selectHMMR}
\title{selectHMMR implements a model selection procedure to select an optimal HMMR
model with unknown structure.}
\usage{
selectHMMR(X, Y, Kmin = 1, Kmax = 10, pmin = 0, pmax = 4,
  criterion = c("BIC", "AIC"), verbose = TRUE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{Kmin}{The minimum number of regimes (HMMR components).}

\item{Kmax}{The maximum number of regimes (HMMR components).}

\item{pmin}{The minimum order of the polynomial regression.}

\item{pmax}{The maximum order of the polynomial regression.}

\item{criterion}{The criterion used to select the HMMR model ("BIC", "AIC").}

\item{verbose}{Optional. A logical value indicating whether or not a summary
of the selected model should be displayed.}
}
\value{
selectHMMR returns an object of class \link{ModelHMMR}
representing the selected HMMR model according to the chosen \code{criterion}.
}
\description{
selectHMMR implements a model selection procedure to select an optimal HMMR
model with unknown structure.
}
\details{
selectHMMR selects the optimal HMMR model among a set of model
candidates by optimizing a model selection criteria, including the Bayesian
Information Criterion (BIC). This function first fits the different HMMR
model candidates by varying the number of regimes \code{K} from \code{Kmin} to \code{Kmax}
and the order of the polynomial regression \code{p} from \code{pmin} to \code{pmax}. The
model having the highest value of the chosen selection criterion is then
selected.
}
\examples{
data(univtoydataset)

selectedhmmr <- selectHMMR(X = univtoydataset$x, Y = univtoydataset$y,
                           Kmin = 2, Kmax = 6, pmin = 0, pmax = 2)

selectedhmmr$plot()
}
\seealso{
\link{ModelHMMR}
}
