\docType{data}
\name{sebor}
\alias{sebor}
\title{Seborrheic Dermatitis Data}
\format{A data frame with 167 observations and 8 variables.}
\description{
  The data are from a randomized clinical trial to compare
  a test treatment to placebo for a seborrheic dermatitis,
  and listings of the data appear in Ramaswamy, Koch, and
  Amara (1997). The variables are as follows:
}
\details{
  \describe{ \item{\code{center}}{a factor vector for eight
  centers} \item{\code{treat}}{a factor with levels
  \code{placebo} and \code{test} for placebo and test
  treatments, resectively} \item{\code{score1}}{a numeric
  vector for patient global scores for the face according
  to 6 categories (0 = cleared, 1 = excellent improvement,
  2 = moderate improvement, 3 = slight improvement, 4 = no
  change, 5 = exacerbation)} \item{\code{score2}}{a numeric
  vector for patient global scores for the scalp with same
  categories as \code{score1}} \item{\code{score3}}{a
  numeric vector for patient global scores for the chest
  with same categories as \code{score1}}
  \item{\code{severity1}}{a numeric vector for the baseline
  desease severity for the face according to 3 categories
  (1 = mild, 2 = moderate, 3 = severe)}
  \item{\code{severity2}}{a numeric vector for the baseline
  desease severity for the scalp with same categories as
  \code{severity1}} \item{\code{severity3}}{a numeric
  vector for the baseline desease severity for the chest
  with same categories as \code{severity1}} }
}
\references{
  Ramaswamy R, Koch G, Amara I (1997). "Application of rank
  analysis of covariance methods to analysis of multiple
  anatomical regions with treatment for seborrheic
  dermatitis." Journal of Biopharmaceutical Statistics,
  7(3), 403--416.
}
\keyword{datasets}

