% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-standard-types-doc.R
\name{non-standard-types}
\alias{non-standard-types}
\title{Tips for chopping non-standard types}
\description{
Santoku can handle many non-standard types.
}
\details{
\itemize{
\item If objects can be compared using \code{<}, \code{==} etc. then they should
be choppable.
\item Objects which can't be converted to numeric are handled within R code,
which may be slower.
\item Character \code{x} and \code{breaks} are chopped with a warning.
\item If \code{x} and \code{breaks} are not the same type, they should be able to
be cast to the same type using \code{\link[vctrs:vec_cast]{vctrs::vec_cast_common()}}.
\item Not all chopping operations make sense, for example, \code{\link[=chop_mean_sd]{chop_mean_sd()}}
on a character vector.
\item If you get errors, try setting \code{extend = FALSE} (but also file a bug report).
\item To request support for a type, open an issue on Github.
}
}
\seealso{
brk-width-for-Datetime
}
