% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_range_to_chapter_structure.R
\name{add_n_range_to_chapter_structure}
\alias{add_n_range_to_chapter_structure}
\title{Add Sample Size Range to Chapter Structure}
\usage{
add_n_range_to_chapter_structure(
  chapter_structure,
  data,
  glue_template_1 = "{n}",
  glue_template_2 = "[{n[1]}-{n[2]}]",
  variable_name = ".n_range"
)
}
\arguments{
\item{chapter_structure}{A grouped tibble. If not grouped, will give a warning
and continue with rowwise processing, which is unlikely what you want.}

\item{data}{The raw data, with matching column names as in
\code{chapter_structure$.variable_name_dep}.}

\item{glue_template_1, glue_template_2}{Glue templates.}

\item{variable_name}{String, name of new variable to attach.
Defaults to ".n_range"}
}
\value{
chapter_structure with a new variable added. Grouped as before.
}
\description{
Takes \code{chapter_structure} and \code{data} and returns the \code{chapter_structure} with
an attached variable containing a string with the sample size-range (or
single value if min=max). Allows specifying the glue_template_1 (single value)
and glue_template_2 (for min and max values).
}
\keyword{internal}
